/*
 * Decompiled with CFR 0.152.
 */
package com.ycloud.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ycloud.client.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Full contact name formatted as a name object.")
public class WhatsappMessageContactName {
    public static final String SERIALIZED_NAME_FORMATTED_NAME = "formatted_name";
    @SerializedName(value="formatted_name")
    private String formattedName;
    public static final String SERIALIZED_NAME_FIRST_NAME = "first_name";
    @SerializedName(value="first_name")
    private String firstName;
    public static final String SERIALIZED_NAME_LAST_NAME = "last_name";
    @SerializedName(value="last_name")
    private String lastName;
    public static final String SERIALIZED_NAME_MIDDLE_NAME = "middle_name";
    @SerializedName(value="middle_name")
    private String middleName;
    public static final String SERIALIZED_NAME_SUFFIX = "suffix";
    @SerializedName(value="suffix")
    private String suffix;
    public static final String SERIALIZED_NAME_PREFIX = "prefix";
    @SerializedName(value="prefix")
    private String prefix;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public WhatsappMessageContactName formattedName(String formattedName) {
        this.formattedName = formattedName;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Full name, as it normally appears.")
    public String getFormattedName() {
        return this.formattedName;
    }

    public void setFormattedName(String formattedName) {
        this.formattedName = formattedName;
    }

    public WhatsappMessageContactName firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="First name.")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public WhatsappMessageContactName lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Last name.")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public WhatsappMessageContactName middleName(String middleName) {
        this.middleName = middleName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Middle name.")
    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public WhatsappMessageContactName suffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name suffix.")
    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public WhatsappMessageContactName prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name prefix.")
    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public WhatsappMessageContactName putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WhatsappMessageContactName whatsappMessageContactName = (WhatsappMessageContactName)o;
        return Objects.equals(this.formattedName, whatsappMessageContactName.formattedName) && Objects.equals(this.firstName, whatsappMessageContactName.firstName) && Objects.equals(this.lastName, whatsappMessageContactName.lastName) && Objects.equals(this.middleName, whatsappMessageContactName.middleName) && Objects.equals(this.suffix, whatsappMessageContactName.suffix) && Objects.equals(this.prefix, whatsappMessageContactName.prefix) && Objects.equals(this.additionalProperties, whatsappMessageContactName.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.formattedName, this.firstName, this.lastName, this.middleName, this.suffix, this.prefix, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WhatsappMessageContactName {\n");
        sb.append("    formattedName: ").append(this.toIndentedString(this.formattedName)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    middleName: ").append(this.toIndentedString(this.middleName)).append("\n");
        sb.append("    suffix: ").append(this.toIndentedString(this.suffix)).append("\n");
        sb.append("    prefix: ").append(this.toIndentedString(this.prefix)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in WhatsappMessageContactName is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FORMATTED_NAME) != null && !jsonObj.get(SERIALIZED_NAME_FORMATTED_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `formatted_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FORMATTED_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FIRST_NAME) != null && !jsonObj.get(SERIALIZED_NAME_FIRST_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `first_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FIRST_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LAST_NAME) != null && !jsonObj.get(SERIALIZED_NAME_LAST_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `last_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LAST_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MIDDLE_NAME) != null && !jsonObj.get(SERIALIZED_NAME_MIDDLE_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `middle_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MIDDLE_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUFFIX) != null && !jsonObj.get(SERIALIZED_NAME_SUFFIX).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `suffix` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUFFIX).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PREFIX) != null && !jsonObj.get(SERIALIZED_NAME_PREFIX).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `prefix` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PREFIX).toString()));
        }
    }

    public static WhatsappMessageContactName fromJson(String jsonString) throws IOException {
        return (WhatsappMessageContactName)JSON.getGson().fromJson(jsonString, WhatsappMessageContactName.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_FORMATTED_NAME);
        openapiFields.add(SERIALIZED_NAME_FIRST_NAME);
        openapiFields.add(SERIALIZED_NAME_LAST_NAME);
        openapiFields.add(SERIALIZED_NAME_MIDDLE_NAME);
        openapiFields.add(SERIALIZED_NAME_SUFFIX);
        openapiFields.add(SERIALIZED_NAME_PREFIX);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_FORMATTED_NAME);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!WhatsappMessageContactName.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(WhatsappMessageContactName.class));
            return new TypeAdapter<WhatsappMessageContactName>(){

                public void write(JsonWriter out, WhatsappMessageContactName value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public WhatsappMessageContactName read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    WhatsappMessageContactName.validateJsonObject(jsonObj);
                    WhatsappMessageContactName instance = (WhatsappMessageContactName)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

