/*
 * Decompiled with CFR 0.152.
 */
package com.ycloud.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ycloud.client.JSON;
import com.ycloud.client.model.WhatsappMessageMedia;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="[WhatsApp Header Object](https://developers.facebook.com/docs/whatsapp/cloud-api/reference/messages#header-object).")
public class WhatsappMessageInteractiveHeader {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_TEXT = "text";
    @SerializedName(value="text")
    private String text;
    public static final String SERIALIZED_NAME_IMAGE = "image";
    @SerializedName(value="image")
    private WhatsappMessageMedia image;
    public static final String SERIALIZED_NAME_VIDEO = "video";
    @SerializedName(value="video")
    private WhatsappMessageMedia video;
    public static final String SERIALIZED_NAME_DOCUMENT = "document";
    @SerializedName(value="document")
    private WhatsappMessageMedia document;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public WhatsappMessageInteractiveHeader type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The header type you would like to use. - `text`: Used for List Messages and Reply Buttons. - `video`: Used for Reply Buttons. - `image`: Used for Reply Buttons. - `document`: Used for Reply Buttons.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public WhatsappMessageInteractiveHeader text(String text) {
        this.text = text;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Text for the header. Formatting allows emojis, but not markdown.")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public WhatsappMessageInteractiveHeader image(WhatsappMessageMedia image) {
        this.image = image;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappMessageMedia getImage() {
        return this.image;
    }

    public void setImage(WhatsappMessageMedia image) {
        this.image = image;
    }

    public WhatsappMessageInteractiveHeader video(WhatsappMessageMedia video) {
        this.video = video;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappMessageMedia getVideo() {
        return this.video;
    }

    public void setVideo(WhatsappMessageMedia video) {
        this.video = video;
    }

    public WhatsappMessageInteractiveHeader document(WhatsappMessageMedia document) {
        this.document = document;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappMessageMedia getDocument() {
        return this.document;
    }

    public void setDocument(WhatsappMessageMedia document) {
        this.document = document;
    }

    public WhatsappMessageInteractiveHeader putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WhatsappMessageInteractiveHeader whatsappMessageInteractiveHeader = (WhatsappMessageInteractiveHeader)o;
        return Objects.equals((Object)this.type, (Object)whatsappMessageInteractiveHeader.type) && Objects.equals(this.text, whatsappMessageInteractiveHeader.text) && Objects.equals(this.image, whatsappMessageInteractiveHeader.image) && Objects.equals(this.video, whatsappMessageInteractiveHeader.video) && Objects.equals(this.document, whatsappMessageInteractiveHeader.document) && Objects.equals(this.additionalProperties, whatsappMessageInteractiveHeader.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.text, this.image, this.video, this.document, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WhatsappMessageInteractiveHeader {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    video: ").append(this.toIndentedString(this.video)).append("\n");
        sb.append("    document: ").append(this.toIndentedString(this.document)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in WhatsappMessageInteractiveHeader is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TEXT) != null && !jsonObj.get(SERIALIZED_NAME_TEXT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `text` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TEXT).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_IMAGE) != null) {
            WhatsappMessageMedia.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_IMAGE));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_VIDEO) != null) {
            WhatsappMessageMedia.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_VIDEO));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_DOCUMENT) != null) {
            WhatsappMessageMedia.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_DOCUMENT));
        }
    }

    public static WhatsappMessageInteractiveHeader fromJson(String jsonString) throws IOException {
        return (WhatsappMessageInteractiveHeader)JSON.getGson().fromJson(jsonString, WhatsappMessageInteractiveHeader.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_TEXT);
        openapiFields.add(SERIALIZED_NAME_IMAGE);
        openapiFields.add(SERIALIZED_NAME_VIDEO);
        openapiFields.add(SERIALIZED_NAME_DOCUMENT);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!WhatsappMessageInteractiveHeader.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(WhatsappMessageInteractiveHeader.class));
            return new TypeAdapter<WhatsappMessageInteractiveHeader>(){

                public void write(JsonWriter out, WhatsappMessageInteractiveHeader value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public WhatsappMessageInteractiveHeader read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    WhatsappMessageInteractiveHeader.validateJsonObject(jsonObj);
                    WhatsappMessageInteractiveHeader instance = (WhatsappMessageInteractiveHeader)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        TEXT("text"),
        IMAGE("image"),
        VIDEO("video"),
        DOCUMENT("document");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

