/*
 * Decompiled with CFR 0.152.
 */
package com.ycloud.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ycloud.client.JSON;
import com.ycloud.client.model.WhatsappMessageMedia;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="See [Parameter Object](https://developers.facebook.com/docs/whatsapp/cloud-api/reference/messages#parameter-object), [Button Parameter Object](https://developers.facebook.com/docs/whatsapp/cloud-api/reference/messages#button-parameter-object.")
public class WhatsappMessageTemplateComponentsInnerParametersInner {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_TEXT = "text";
    @SerializedName(value="text")
    private String text;
    public static final String SERIALIZED_NAME_PAYLOAD = "payload";
    @SerializedName(value="payload")
    private String payload;
    public static final String SERIALIZED_NAME_IMAGE = "image";
    @SerializedName(value="image")
    private WhatsappMessageMedia image;
    public static final String SERIALIZED_NAME_VIDEO = "video";
    @SerializedName(value="video")
    private WhatsappMessageMedia video;
    public static final String SERIALIZED_NAME_DOCUMENT = "document";
    @SerializedName(value="document")
    private WhatsappMessageMedia document;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public WhatsappMessageTemplateComponentsInnerParametersInner type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Describes the parameter type.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public WhatsappMessageTemplateComponentsInnerParametersInner text(String text) {
        this.text = text;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Required when `type` = `text`. The message's text. For the header component, the character limit is 60 characters. For the body component, the character limit is 1024 characters. For url buttons, it indicates the developer-provided suffix that is appended to the predefined prefix URL in the template.")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public WhatsappMessageTemplateComponentsInnerParametersInner payload(String payload) {
        this.payload = payload;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Required for `quick_reply` buttons. Developer-defined payload that is returned when the button is clicked in addition to the display text on the button.")
    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public WhatsappMessageTemplateComponentsInnerParametersInner image(WhatsappMessageMedia image) {
        this.image = image;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappMessageMedia getImage() {
        return this.image;
    }

    public void setImage(WhatsappMessageMedia image) {
        this.image = image;
    }

    public WhatsappMessageTemplateComponentsInnerParametersInner video(WhatsappMessageMedia video) {
        this.video = video;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappMessageMedia getVideo() {
        return this.video;
    }

    public void setVideo(WhatsappMessageMedia video) {
        this.video = video;
    }

    public WhatsappMessageTemplateComponentsInnerParametersInner document(WhatsappMessageMedia document) {
        this.document = document;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappMessageMedia getDocument() {
        return this.document;
    }

    public void setDocument(WhatsappMessageMedia document) {
        this.document = document;
    }

    public WhatsappMessageTemplateComponentsInnerParametersInner putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WhatsappMessageTemplateComponentsInnerParametersInner whatsappMessageTemplateComponentsInnerParametersInner = (WhatsappMessageTemplateComponentsInnerParametersInner)o;
        return Objects.equals((Object)this.type, (Object)whatsappMessageTemplateComponentsInnerParametersInner.type) && Objects.equals(this.text, whatsappMessageTemplateComponentsInnerParametersInner.text) && Objects.equals(this.payload, whatsappMessageTemplateComponentsInnerParametersInner.payload) && Objects.equals(this.image, whatsappMessageTemplateComponentsInnerParametersInner.image) && Objects.equals(this.video, whatsappMessageTemplateComponentsInnerParametersInner.video) && Objects.equals(this.document, whatsappMessageTemplateComponentsInnerParametersInner.document) && Objects.equals(this.additionalProperties, whatsappMessageTemplateComponentsInnerParametersInner.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.text, this.payload, this.image, this.video, this.document, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WhatsappMessageTemplateComponentsInnerParametersInner {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    payload: ").append(this.toIndentedString(this.payload)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    video: ").append(this.toIndentedString(this.video)).append("\n");
        sb.append("    document: ").append(this.toIndentedString(this.document)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in WhatsappMessageTemplateComponentsInnerParametersInner is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TEXT) != null && !jsonObj.get(SERIALIZED_NAME_TEXT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `text` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TEXT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PAYLOAD) != null && !jsonObj.get(SERIALIZED_NAME_PAYLOAD).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `payload` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PAYLOAD).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_IMAGE) != null) {
            WhatsappMessageMedia.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_IMAGE));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_VIDEO) != null) {
            WhatsappMessageMedia.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_VIDEO));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_DOCUMENT) != null) {
            WhatsappMessageMedia.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_DOCUMENT));
        }
    }

    public static WhatsappMessageTemplateComponentsInnerParametersInner fromJson(String jsonString) throws IOException {
        return (WhatsappMessageTemplateComponentsInnerParametersInner)JSON.getGson().fromJson(jsonString, WhatsappMessageTemplateComponentsInnerParametersInner.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_TEXT);
        openapiFields.add(SERIALIZED_NAME_PAYLOAD);
        openapiFields.add(SERIALIZED_NAME_IMAGE);
        openapiFields.add(SERIALIZED_NAME_VIDEO);
        openapiFields.add(SERIALIZED_NAME_DOCUMENT);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!WhatsappMessageTemplateComponentsInnerParametersInner.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(WhatsappMessageTemplateComponentsInnerParametersInner.class));
            return new TypeAdapter<WhatsappMessageTemplateComponentsInnerParametersInner>(){

                public void write(JsonWriter out, WhatsappMessageTemplateComponentsInnerParametersInner value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public WhatsappMessageTemplateComponentsInnerParametersInner read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    WhatsappMessageTemplateComponentsInnerParametersInner.validateJsonObject(jsonObj);
                    WhatsappMessageTemplateComponentsInnerParametersInner instance = (WhatsappMessageTemplateComponentsInnerParametersInner)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        TEXT("text"),
        IMAGE("image"),
        VIDEO("video"),
        DOCUMENT("document"),
        PAYLOAD("payload");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

