/*
 * Decompiled with CFR 0.152.
 */
package com.ycloud.client.api;

import com.google.gson.reflect.TypeToken;
import com.ycloud.client.ApiCallback;
import com.ycloud.client.ApiClient;
import com.ycloud.client.ApiException;
import com.ycloud.client.ApiResponse;
import com.ycloud.client.Configuration;
import com.ycloud.client.Pair;
import com.ycloud.client.model.WebhookEndpoint;
import com.ycloud.client.model.WebhookEndpointCreateRequest;
import com.ycloud.client.model.WebhookEndpointPage;
import com.ycloud.client.model.WebhookEndpointUpdateRequest;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class WebhookEndpointsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public WebhookEndpointsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WebhookEndpointsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createCall(WebhookEndpointCreateRequest webhookEndpointCreateRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        WebhookEndpointCreateRequest localVarPostBody = webhookEndpointCreateRequest;
        String localVarPath = "/webhookEndpoints";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createValidateBeforeCall(WebhookEndpointCreateRequest webhookEndpointCreateRequest, ApiCallback _callback) throws ApiException {
        if (webhookEndpointCreateRequest == null) {
            throw new ApiException("Missing the required parameter 'webhookEndpointCreateRequest' when calling create(Async)");
        }
        Call localVarCall = this.createCall(webhookEndpointCreateRequest, _callback);
        return localVarCall;
    }

    public WebhookEndpoint create(WebhookEndpointCreateRequest webhookEndpointCreateRequest) throws ApiException {
        ApiResponse<WebhookEndpoint> localVarResp = this.createWithHttpInfo(webhookEndpointCreateRequest);
        return localVarResp.getData();
    }

    public ApiResponse<WebhookEndpoint> createWithHttpInfo(WebhookEndpointCreateRequest webhookEndpointCreateRequest) throws ApiException {
        Call localVarCall = this.createValidateBeforeCall(webhookEndpointCreateRequest, null);
        Type localVarReturnType = new TypeToken<WebhookEndpoint>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createAsync(WebhookEndpointCreateRequest webhookEndpointCreateRequest, ApiCallback<WebhookEndpoint> _callback) throws ApiException {
        Call localVarCall = this.createValidateBeforeCall(webhookEndpointCreateRequest, _callback);
        Type localVarReturnType = new TypeToken<WebhookEndpoint>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteCall(String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/webhookEndpoints/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling delete(Async)");
        }
        Call localVarCall = this.deleteCall(id, _callback);
        return localVarCall;
    }

    public WebhookEndpoint delete(String id) throws ApiException {
        ApiResponse<WebhookEndpoint> localVarResp = this.deleteWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<WebhookEndpoint> deleteWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.deleteValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<WebhookEndpoint>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteAsync(String id, ApiCallback<WebhookEndpoint> _callback) throws ApiException {
        Call localVarCall = this.deleteValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<WebhookEndpoint>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call listCall(Integer page, Integer limit, Boolean includeTotal, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/webhookEndpoints";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (includeTotal != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("includeTotal", includeTotal));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listValidateBeforeCall(Integer page, Integer limit, Boolean includeTotal, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listCall(page, limit, includeTotal, _callback);
        return localVarCall;
    }

    private ApiResponse<WebhookEndpointPage> listWithHttpInfo(Integer page, Integer limit, Boolean includeTotal) throws ApiException {
        Call localVarCall = this.listValidateBeforeCall(page, limit, includeTotal, null);
        Type localVarReturnType = new TypeToken<WebhookEndpointPage>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listAsync(Integer page, Integer limit, Boolean includeTotal, ApiCallback<WebhookEndpointPage> _callback) throws ApiException {
        Call localVarCall = this.listValidateBeforeCall(page, limit, includeTotal, _callback);
        Type localVarReturnType = new TypeToken<WebhookEndpointPage>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public ApiListRequest list() {
        return new ApiListRequest();
    }

    public Call retrieveCall(String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/webhookEndpoints/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call retrieveValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling retrieve(Async)");
        }
        Call localVarCall = this.retrieveCall(id, _callback);
        return localVarCall;
    }

    public WebhookEndpoint retrieve(String id) throws ApiException {
        ApiResponse<WebhookEndpoint> localVarResp = this.retrieveWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<WebhookEndpoint> retrieveWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.retrieveValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<WebhookEndpoint>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call retrieveAsync(String id, ApiCallback<WebhookEndpoint> _callback) throws ApiException {
        Call localVarCall = this.retrieveValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<WebhookEndpoint>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call rotateSecretCall(String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/webhookEndpoints/{id}/rotateSecret".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call rotateSecretValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling rotateSecret(Async)");
        }
        Call localVarCall = this.rotateSecretCall(id, _callback);
        return localVarCall;
    }

    public WebhookEndpoint rotateSecret(String id) throws ApiException {
        ApiResponse<WebhookEndpoint> localVarResp = this.rotateSecretWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<WebhookEndpoint> rotateSecretWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.rotateSecretValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<WebhookEndpoint>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call rotateSecretAsync(String id, ApiCallback<WebhookEndpoint> _callback) throws ApiException {
        Call localVarCall = this.rotateSecretValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<WebhookEndpoint>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateCall(String id, WebhookEndpointUpdateRequest webhookEndpointUpdateRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        WebhookEndpointUpdateRequest localVarPostBody = webhookEndpointUpdateRequest;
        String localVarPath = "/webhookEndpoints/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateValidateBeforeCall(String id, WebhookEndpointUpdateRequest webhookEndpointUpdateRequest, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling update(Async)");
        }
        if (webhookEndpointUpdateRequest == null) {
            throw new ApiException("Missing the required parameter 'webhookEndpointUpdateRequest' when calling update(Async)");
        }
        Call localVarCall = this.updateCall(id, webhookEndpointUpdateRequest, _callback);
        return localVarCall;
    }

    public WebhookEndpoint update(String id, WebhookEndpointUpdateRequest webhookEndpointUpdateRequest) throws ApiException {
        ApiResponse<WebhookEndpoint> localVarResp = this.updateWithHttpInfo(id, webhookEndpointUpdateRequest);
        return localVarResp.getData();
    }

    public ApiResponse<WebhookEndpoint> updateWithHttpInfo(String id, WebhookEndpointUpdateRequest webhookEndpointUpdateRequest) throws ApiException {
        Call localVarCall = this.updateValidateBeforeCall(id, webhookEndpointUpdateRequest, null);
        Type localVarReturnType = new TypeToken<WebhookEndpoint>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateAsync(String id, WebhookEndpointUpdateRequest webhookEndpointUpdateRequest, ApiCallback<WebhookEndpoint> _callback) throws ApiException {
        Call localVarCall = this.updateValidateBeforeCall(id, webhookEndpointUpdateRequest, _callback);
        Type localVarReturnType = new TypeToken<WebhookEndpoint>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class ApiListRequest {
        private Integer page;
        private Integer limit;
        private Boolean includeTotal;

        private ApiListRequest() {
        }

        public ApiListRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public ApiListRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public ApiListRequest includeTotal(Boolean includeTotal) {
            this.includeTotal = includeTotal;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return WebhookEndpointsApi.this.listCall(this.page, this.limit, this.includeTotal, _callback);
        }

        public WebhookEndpointPage execute() throws ApiException {
            ApiResponse localVarResp = WebhookEndpointsApi.this.listWithHttpInfo(this.page, this.limit, this.includeTotal);
            return (WebhookEndpointPage)localVarResp.getData();
        }

        public ApiResponse<WebhookEndpointPage> executeWithHttpInfo() throws ApiException {
            return WebhookEndpointsApi.this.listWithHttpInfo(this.page, this.limit, this.includeTotal);
        }

        public Call executeAsync(ApiCallback<WebhookEndpointPage> _callback) throws ApiException {
            return WebhookEndpointsApi.this.listAsync(this.page, this.limit, this.includeTotal, _callback);
        }
    }
}

