/*
 * Decompiled with CFR 0.152.
 */
package com.ycloud.client.api;

import com.google.gson.reflect.TypeToken;
import com.ycloud.client.ApiCallback;
import com.ycloud.client.ApiClient;
import com.ycloud.client.ApiException;
import com.ycloud.client.ApiResponse;
import com.ycloud.client.Configuration;
import com.ycloud.client.Pair;
import com.ycloud.client.model.WhatsappMessage;
import com.ycloud.client.model.WhatsappMessageSendRequest;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class WhatsappMessagesApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public WhatsappMessagesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WhatsappMessagesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call retrieveCall(String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/whatsapp/messages/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call retrieveValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling retrieve(Async)");
        }
        Call localVarCall = this.retrieveCall(id, _callback);
        return localVarCall;
    }

    public WhatsappMessage retrieve(String id) throws ApiException {
        ApiResponse<WhatsappMessage> localVarResp = this.retrieveWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<WhatsappMessage> retrieveWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.retrieveValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<WhatsappMessage>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call retrieveAsync(String id, ApiCallback<WhatsappMessage> _callback) throws ApiException {
        Call localVarCall = this.retrieveValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<WhatsappMessage>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call sendCall(WhatsappMessageSendRequest whatsappMessageSendRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        WhatsappMessageSendRequest localVarPostBody = whatsappMessageSendRequest;
        String localVarPath = "/whatsapp/messages";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call sendValidateBeforeCall(WhatsappMessageSendRequest whatsappMessageSendRequest, ApiCallback _callback) throws ApiException {
        if (whatsappMessageSendRequest == null) {
            throw new ApiException("Missing the required parameter 'whatsappMessageSendRequest' when calling send(Async)");
        }
        Call localVarCall = this.sendCall(whatsappMessageSendRequest, _callback);
        return localVarCall;
    }

    public WhatsappMessage send(WhatsappMessageSendRequest whatsappMessageSendRequest) throws ApiException {
        ApiResponse<WhatsappMessage> localVarResp = this.sendWithHttpInfo(whatsappMessageSendRequest);
        return localVarResp.getData();
    }

    public ApiResponse<WhatsappMessage> sendWithHttpInfo(WhatsappMessageSendRequest whatsappMessageSendRequest) throws ApiException {
        Call localVarCall = this.sendValidateBeforeCall(whatsappMessageSendRequest, null);
        Type localVarReturnType = new TypeToken<WhatsappMessage>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call sendAsync(WhatsappMessageSendRequest whatsappMessageSendRequest, ApiCallback<WhatsappMessage> _callback) throws ApiException {
        Call localVarCall = this.sendValidateBeforeCall(whatsappMessageSendRequest, _callback);
        Type localVarReturnType = new TypeToken<WhatsappMessage>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

