/*
 * Decompiled with CFR 0.152.
 */
package com.ycloud.client.api;

import com.google.gson.reflect.TypeToken;
import com.ycloud.client.ApiCallback;
import com.ycloud.client.ApiClient;
import com.ycloud.client.ApiException;
import com.ycloud.client.ApiResponse;
import com.ycloud.client.Configuration;
import com.ycloud.client.Pair;
import com.ycloud.client.model.WhatsappTemplate;
import com.ycloud.client.model.WhatsappTemplateCreateRequest;
import com.ycloud.client.model.WhatsappTemplateEditRequest;
import com.ycloud.client.model.WhatsappTemplatePage;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class WhatsappTemplatesApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public WhatsappTemplatesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WhatsappTemplatesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createCall(WhatsappTemplateCreateRequest whatsappTemplateCreateRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        WhatsappTemplateCreateRequest localVarPostBody = whatsappTemplateCreateRequest;
        String localVarPath = "/whatsapp/templates";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createValidateBeforeCall(WhatsappTemplateCreateRequest whatsappTemplateCreateRequest, ApiCallback _callback) throws ApiException {
        if (whatsappTemplateCreateRequest == null) {
            throw new ApiException("Missing the required parameter 'whatsappTemplateCreateRequest' when calling create(Async)");
        }
        Call localVarCall = this.createCall(whatsappTemplateCreateRequest, _callback);
        return localVarCall;
    }

    public WhatsappTemplate create(WhatsappTemplateCreateRequest whatsappTemplateCreateRequest) throws ApiException {
        ApiResponse<WhatsappTemplate> localVarResp = this.createWithHttpInfo(whatsappTemplateCreateRequest);
        return localVarResp.getData();
    }

    public ApiResponse<WhatsappTemplate> createWithHttpInfo(WhatsappTemplateCreateRequest whatsappTemplateCreateRequest) throws ApiException {
        Call localVarCall = this.createValidateBeforeCall(whatsappTemplateCreateRequest, null);
        Type localVarReturnType = new TypeToken<WhatsappTemplate>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createAsync(WhatsappTemplateCreateRequest whatsappTemplateCreateRequest, ApiCallback<WhatsappTemplate> _callback) throws ApiException {
        Call localVarCall = this.createValidateBeforeCall(whatsappTemplateCreateRequest, _callback);
        Type localVarReturnType = new TypeToken<WhatsappTemplate>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteByNameCall(String wabaId, String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/whatsapp/templates/{wabaId}/{name}".replaceAll("\\{wabaId\\}", this.localVarApiClient.escapeString(wabaId.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteByNameValidateBeforeCall(String wabaId, String name, ApiCallback _callback) throws ApiException {
        if (wabaId == null) {
            throw new ApiException("Missing the required parameter 'wabaId' when calling deleteByName(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteByName(Async)");
        }
        Call localVarCall = this.deleteByNameCall(wabaId, name, _callback);
        return localVarCall;
    }

    public List<WhatsappTemplate> deleteByName(String wabaId, String name) throws ApiException {
        ApiResponse<List<WhatsappTemplate>> localVarResp = this.deleteByNameWithHttpInfo(wabaId, name);
        return localVarResp.getData();
    }

    public ApiResponse<List<WhatsappTemplate>> deleteByNameWithHttpInfo(String wabaId, String name) throws ApiException {
        Call localVarCall = this.deleteByNameValidateBeforeCall(wabaId, name, null);
        Type localVarReturnType = new TypeToken<List<WhatsappTemplate>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteByNameAsync(String wabaId, String name, ApiCallback<List<WhatsappTemplate>> _callback) throws ApiException {
        Call localVarCall = this.deleteByNameValidateBeforeCall(wabaId, name, _callback);
        Type localVarReturnType = new TypeToken<List<WhatsappTemplate>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call editByNameAndLanguageCall(String wabaId, String name, String language, WhatsappTemplateEditRequest whatsappTemplateEditRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        WhatsappTemplateEditRequest localVarPostBody = whatsappTemplateEditRequest;
        String localVarPath = "/whatsapp/templates/{wabaId}/{name}/{language}".replaceAll("\\{wabaId\\}", this.localVarApiClient.escapeString(wabaId.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString())).replaceAll("\\{language\\}", this.localVarApiClient.escapeString(language.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call editByNameAndLanguageValidateBeforeCall(String wabaId, String name, String language, WhatsappTemplateEditRequest whatsappTemplateEditRequest, ApiCallback _callback) throws ApiException {
        if (wabaId == null) {
            throw new ApiException("Missing the required parameter 'wabaId' when calling editByNameAndLanguage(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling editByNameAndLanguage(Async)");
        }
        if (language == null) {
            throw new ApiException("Missing the required parameter 'language' when calling editByNameAndLanguage(Async)");
        }
        Call localVarCall = this.editByNameAndLanguageCall(wabaId, name, language, whatsappTemplateEditRequest, _callback);
        return localVarCall;
    }

    public WhatsappTemplate editByNameAndLanguage(String wabaId, String name, String language, WhatsappTemplateEditRequest whatsappTemplateEditRequest) throws ApiException {
        ApiResponse<WhatsappTemplate> localVarResp = this.editByNameAndLanguageWithHttpInfo(wabaId, name, language, whatsappTemplateEditRequest);
        return localVarResp.getData();
    }

    public ApiResponse<WhatsappTemplate> editByNameAndLanguageWithHttpInfo(String wabaId, String name, String language, WhatsappTemplateEditRequest whatsappTemplateEditRequest) throws ApiException {
        Call localVarCall = this.editByNameAndLanguageValidateBeforeCall(wabaId, name, language, whatsappTemplateEditRequest, null);
        Type localVarReturnType = new TypeToken<WhatsappTemplate>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call editByNameAndLanguageAsync(String wabaId, String name, String language, WhatsappTemplateEditRequest whatsappTemplateEditRequest, ApiCallback<WhatsappTemplate> _callback) throws ApiException {
        Call localVarCall = this.editByNameAndLanguageValidateBeforeCall(wabaId, name, language, whatsappTemplateEditRequest, _callback);
        Type localVarReturnType = new TypeToken<WhatsappTemplate>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call listCall(Integer page, Integer limit, Boolean includeTotal, String filterWabaId, String filterName, String filterLanguage, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/whatsapp/templates";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (includeTotal != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("includeTotal", includeTotal));
        }
        if (filterWabaId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter.wabaId", filterWabaId));
        }
        if (filterName != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter.name", filterName));
        }
        if (filterLanguage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter.language", filterLanguage));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listValidateBeforeCall(Integer page, Integer limit, Boolean includeTotal, String filterWabaId, String filterName, String filterLanguage, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listCall(page, limit, includeTotal, filterWabaId, filterName, filterLanguage, _callback);
        return localVarCall;
    }

    private ApiResponse<WhatsappTemplatePage> listWithHttpInfo(Integer page, Integer limit, Boolean includeTotal, String filterWabaId, String filterName, String filterLanguage) throws ApiException {
        Call localVarCall = this.listValidateBeforeCall(page, limit, includeTotal, filterWabaId, filterName, filterLanguage, null);
        Type localVarReturnType = new TypeToken<WhatsappTemplatePage>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listAsync(Integer page, Integer limit, Boolean includeTotal, String filterWabaId, String filterName, String filterLanguage, ApiCallback<WhatsappTemplatePage> _callback) throws ApiException {
        Call localVarCall = this.listValidateBeforeCall(page, limit, includeTotal, filterWabaId, filterName, filterLanguage, _callback);
        Type localVarReturnType = new TypeToken<WhatsappTemplatePage>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public ApiListRequest list() {
        return new ApiListRequest();
    }

    public Call retrieveByNameAndLanguageCall(String wabaId, String name, String language, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/whatsapp/templates/{wabaId}/{name}/{language}".replaceAll("\\{wabaId\\}", this.localVarApiClient.escapeString(wabaId.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString())).replaceAll("\\{language\\}", this.localVarApiClient.escapeString(language.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call retrieveByNameAndLanguageValidateBeforeCall(String wabaId, String name, String language, ApiCallback _callback) throws ApiException {
        if (wabaId == null) {
            throw new ApiException("Missing the required parameter 'wabaId' when calling retrieveByNameAndLanguage(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling retrieveByNameAndLanguage(Async)");
        }
        if (language == null) {
            throw new ApiException("Missing the required parameter 'language' when calling retrieveByNameAndLanguage(Async)");
        }
        Call localVarCall = this.retrieveByNameAndLanguageCall(wabaId, name, language, _callback);
        return localVarCall;
    }

    public WhatsappTemplate retrieveByNameAndLanguage(String wabaId, String name, String language) throws ApiException {
        ApiResponse<WhatsappTemplate> localVarResp = this.retrieveByNameAndLanguageWithHttpInfo(wabaId, name, language);
        return localVarResp.getData();
    }

    public ApiResponse<WhatsappTemplate> retrieveByNameAndLanguageWithHttpInfo(String wabaId, String name, String language) throws ApiException {
        Call localVarCall = this.retrieveByNameAndLanguageValidateBeforeCall(wabaId, name, language, null);
        Type localVarReturnType = new TypeToken<WhatsappTemplate>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call retrieveByNameAndLanguageAsync(String wabaId, String name, String language, ApiCallback<WhatsappTemplate> _callback) throws ApiException {
        Call localVarCall = this.retrieveByNameAndLanguageValidateBeforeCall(wabaId, name, language, _callback);
        Type localVarReturnType = new TypeToken<WhatsappTemplate>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class ApiListRequest {
        private Integer page;
        private Integer limit;
        private Boolean includeTotal;
        private String filterWabaId;
        private String filterName;
        private String filterLanguage;

        private ApiListRequest() {
        }

        public ApiListRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public ApiListRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public ApiListRequest includeTotal(Boolean includeTotal) {
            this.includeTotal = includeTotal;
            return this;
        }

        public ApiListRequest filterWabaId(String filterWabaId) {
            this.filterWabaId = filterWabaId;
            return this;
        }

        public ApiListRequest filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        public ApiListRequest filterLanguage(String filterLanguage) {
            this.filterLanguage = filterLanguage;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return WhatsappTemplatesApi.this.listCall(this.page, this.limit, this.includeTotal, this.filterWabaId, this.filterName, this.filterLanguage, _callback);
        }

        public WhatsappTemplatePage execute() throws ApiException {
            ApiResponse localVarResp = WhatsappTemplatesApi.this.listWithHttpInfo(this.page, this.limit, this.includeTotal, this.filterWabaId, this.filterName, this.filterLanguage);
            return (WhatsappTemplatePage)localVarResp.getData();
        }

        public ApiResponse<WhatsappTemplatePage> executeWithHttpInfo() throws ApiException {
            return WhatsappTemplatesApi.this.listWithHttpInfo(this.page, this.limit, this.includeTotal, this.filterWabaId, this.filterName, this.filterLanguage);
        }

        public Call executeAsync(ApiCallback<WhatsappTemplatePage> _callback) throws ApiException {
            return WhatsappTemplatesApi.this.listAsync(this.page, this.limit, this.includeTotal, this.filterWabaId, this.filterName, this.filterLanguage, _callback);
        }
    }
}

