/*
 * Decompiled with CFR 0.152.
 */
package com.ycloud.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ycloud.client.JSON;
import com.ycloud.client.model.EmailContentType;
import com.ycloud.client.model.Mailbox;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Email {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_FROM = "from";
    @SerializedName(value="from")
    private Mailbox from;
    public static final String SERIALIZED_NAME_TO = "to";
    @SerializedName(value="to")
    private List<Mailbox> to = null;
    public static final String SERIALIZED_NAME_CC = "cc";
    @SerializedName(value="cc")
    private List<Mailbox> cc = null;
    public static final String SERIALIZED_NAME_BCC = "bcc";
    @SerializedName(value="bcc")
    private List<Mailbox> bcc = null;
    public static final String SERIALIZED_NAME_REPLY_TO = "replyTo";
    @SerializedName(value="replyTo")
    private List<Mailbox> replyTo = null;
    public static final String SERIALIZED_NAME_SUBJECT = "subject";
    @SerializedName(value="subject")
    private String subject;
    public static final String SERIALIZED_NAME_SUMMARY = "summary";
    @SerializedName(value="summary")
    private String summary;
    public static final String SERIALIZED_NAME_CONTENT_TYPE = "contentType";
    @SerializedName(value="contentType")
    private EmailContentType contentType;
    public static final String SERIALIZED_NAME_EXTERNAL_ID = "externalId";
    @SerializedName(value="externalId")
    private String externalId;
    public static final String SERIALIZED_NAME_CALLBACK_URL = "callbackUrl";
    @SerializedName(value="callbackUrl")
    private String callbackUrl;
    public static final String SERIALIZED_NAME_CREATE_TIME = "createTime";
    @SerializedName(value="createTime")
    private Date createTime;
    public static final String SERIALIZED_NAME_TOTAL_RECIPIENTS = "totalRecipients";
    @SerializedName(value="totalRecipients")
    private Integer totalRecipients;
    public static final String SERIALIZED_NAME_TOTAL_PRICE = "totalPrice";
    @SerializedName(value="totalPrice")
    private Double totalPrice;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Email id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Unique ID for the object.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Email from(Mailbox from) {
        this.from = from;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Mailbox getFrom() {
        return this.from;
    }

    public void setFrom(Mailbox from) {
        this.from = from;
    }

    public Email to(List<Mailbox> to) {
        this.to = to;
        return this;
    }

    public Email addToItem(Mailbox toItem) {
        if (this.to == null) {
            this.to = new ArrayList<Mailbox>();
        }
        this.to.add(toItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The intended recipients' email addresses.")
    public List<Mailbox> getTo() {
        return this.to;
    }

    public void setTo(List<Mailbox> to) {
        this.to = to;
    }

    public Email cc(List<Mailbox> cc) {
        this.cc = cc;
        return this;
    }

    public Email addCcItem(Mailbox ccItem) {
        if (this.cc == null) {
            this.cc = new ArrayList<Mailbox>();
        }
        this.cc.add(ccItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Recipients who will receive a copy of the email.")
    public List<Mailbox> getCc() {
        return this.cc;
    }

    public void setCc(List<Mailbox> cc) {
        this.cc = cc;
    }

    public Email bcc(List<Mailbox> bcc) {
        this.bcc = bcc;
        return this;
    }

    public Email addBccItem(Mailbox bccItem) {
        if (this.bcc == null) {
            this.bcc = new ArrayList<Mailbox>();
        }
        this.bcc.add(bccItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Recipients who will receive a blind carbon copy of the email.")
    public List<Mailbox> getBcc() {
        return this.bcc;
    }

    public void setBcc(List<Mailbox> bcc) {
        this.bcc = bcc;
    }

    public Email replyTo(List<Mailbox> replyTo) {
        this.replyTo = replyTo;
        return this;
    }

    public Email addReplyToItem(Mailbox replyToItem) {
        if (this.replyTo == null) {
            this.replyTo = new ArrayList<Mailbox>();
        }
        this.replyTo.add(replyToItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If this field exists, then the reply should go to the addresses indicated in that field and not to the address(es) indicated in the `from` field.")
    public List<Mailbox> getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(List<Mailbox> replyTo) {
        this.replyTo = replyTo;
    }

    public Email subject(String subject) {
        this.subject = subject;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The email subject, which contains a short string identifying the topic of the message.")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public Email summary(String summary) {
        this.summary = summary;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="This is a summary.", value="This is a summary of your email. Max length: 70.")
    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public Email contentType(EmailContentType contentType) {
        this.contentType = contentType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public EmailContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(EmailContentType contentType) {
        this.contentType = contentType;
    }

    public Email externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A unique string to reference the object. This can be an order number or similar, and can be used to reconcile the object with your internal systems.")
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public Email callbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://httpbin.org/anything?tag=api-email", value="Delivery report URL. You can provide a URL, and we will push the updated status report to your server in time. e.g., https://httpbin.org/anything?tag=api. Note: We recommend configuring Webhook Endpoints instead.")
    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public Email createTime(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2022-06-01T12:00Z", value="The time at which this message was created, formatted in [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339). e.g., `2022-06-01T12:00:00.000Z`.")
    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Email totalRecipients(Integer totalRecipients) {
        this.totalRecipients = totalRecipients;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="3", value="Total recipients of this message, including `to`, `cc` and `bcc`.")
    public Integer getTotalRecipients() {
        return this.totalRecipients;
    }

    public void setTotalRecipients(Integer totalRecipients) {
        this.totalRecipients = totalRecipients;
    }

    public Email totalPrice(Double totalPrice) {
        this.totalPrice = totalPrice;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0.0085", value="Total price of this message.")
    public Double getTotalPrice() {
        return this.totalPrice;
    }

    public void setTotalPrice(Double totalPrice) {
        this.totalPrice = totalPrice;
    }

    public Email currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="USD", value="Price currency. [ISO 4217 currency code](https://en.wikipedia.org/wiki/ISO_4217).")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Email putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Email email = (Email)o;
        return Objects.equals(this.id, email.id) && Objects.equals(this.from, email.from) && Objects.equals(this.to, email.to) && Objects.equals(this.cc, email.cc) && Objects.equals(this.bcc, email.bcc) && Objects.equals(this.replyTo, email.replyTo) && Objects.equals(this.subject, email.subject) && Objects.equals(this.summary, email.summary) && Objects.equals((Object)this.contentType, (Object)email.contentType) && Objects.equals(this.externalId, email.externalId) && Objects.equals(this.callbackUrl, email.callbackUrl) && Objects.equals(this.createTime, email.createTime) && Objects.equals(this.totalRecipients, email.totalRecipients) && Objects.equals(this.totalPrice, email.totalPrice) && Objects.equals(this.currency, email.currency) && Objects.equals(this.additionalProperties, email.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.from, this.to, this.cc, this.bcc, this.replyTo, this.subject, this.summary, this.contentType, this.externalId, this.callbackUrl, this.createTime, this.totalRecipients, this.totalPrice, this.currency, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Email {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    cc: ").append(this.toIndentedString(this.cc)).append("\n");
        sb.append("    bcc: ").append(this.toIndentedString(this.bcc)).append("\n");
        sb.append("    replyTo: ").append(this.toIndentedString(this.replyTo)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    summary: ").append(this.toIndentedString(this.summary)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString((Object)this.contentType)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    callbackUrl: ").append(this.toIndentedString(this.callbackUrl)).append("\n");
        sb.append("    createTime: ").append(this.toIndentedString(this.createTime)).append("\n");
        sb.append("    totalRecipients: ").append(this.toIndentedString(this.totalRecipients)).append("\n");
        sb.append("    totalPrice: ").append(this.toIndentedString(this.totalPrice)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayreplyTo;
        JsonArray jsonArraybcc;
        JsonArray jsonArraycc;
        JsonArray jsonArrayto;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Email is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_FROM) != null) {
            Mailbox.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_FROM));
        }
        if ((jsonArrayto = jsonObj.getAsJsonArray(SERIALIZED_NAME_TO)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TO).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `to` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TO).toString()));
            }
            for (int i = 0; i < jsonArrayto.size(); ++i) {
                Mailbox.validateJsonObject(jsonArrayto.get(i).getAsJsonObject());
            }
        }
        if ((jsonArraycc = jsonObj.getAsJsonArray(SERIALIZED_NAME_CC)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CC).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `cc` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CC).toString()));
            }
            for (int i = 0; i < jsonArraycc.size(); ++i) {
                Mailbox.validateJsonObject(jsonArraycc.get(i).getAsJsonObject());
            }
        }
        if ((jsonArraybcc = jsonObj.getAsJsonArray(SERIALIZED_NAME_BCC)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_BCC).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `bcc` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BCC).toString()));
            }
            for (int i = 0; i < jsonArraybcc.size(); ++i) {
                Mailbox.validateJsonObject(jsonArraybcc.get(i).getAsJsonObject());
            }
        }
        if ((jsonArrayreplyTo = jsonObj.getAsJsonArray(SERIALIZED_NAME_REPLY_TO)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_REPLY_TO).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `replyTo` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REPLY_TO).toString()));
            }
            for (int i = 0; i < jsonArrayreplyTo.size(); ++i) {
                Mailbox.validateJsonObject(jsonArrayreplyTo.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_SUBJECT) != null && !jsonObj.get(SERIALIZED_NAME_SUBJECT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `subject` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUBJECT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUMMARY) != null && !jsonObj.get(SERIALIZED_NAME_SUMMARY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `summary` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUMMARY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXTERNAL_ID) != null && !jsonObj.get(SERIALIZED_NAME_EXTERNAL_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `externalId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXTERNAL_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CALLBACK_URL) != null && !jsonObj.get(SERIALIZED_NAME_CALLBACK_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `callbackUrl` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CALLBACK_URL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CURRENCY) != null && !jsonObj.get(SERIALIZED_NAME_CURRENCY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `currency` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CURRENCY).toString()));
        }
    }

    public static Email fromJson(String jsonString) throws IOException {
        return (Email)JSON.getGson().fromJson(jsonString, Email.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_FROM);
        openapiFields.add(SERIALIZED_NAME_TO);
        openapiFields.add(SERIALIZED_NAME_CC);
        openapiFields.add(SERIALIZED_NAME_BCC);
        openapiFields.add(SERIALIZED_NAME_REPLY_TO);
        openapiFields.add(SERIALIZED_NAME_SUBJECT);
        openapiFields.add(SERIALIZED_NAME_SUMMARY);
        openapiFields.add(SERIALIZED_NAME_CONTENT_TYPE);
        openapiFields.add(SERIALIZED_NAME_EXTERNAL_ID);
        openapiFields.add(SERIALIZED_NAME_CALLBACK_URL);
        openapiFields.add(SERIALIZED_NAME_CREATE_TIME);
        openapiFields.add(SERIALIZED_NAME_TOTAL_RECIPIENTS);
        openapiFields.add(SERIALIZED_NAME_TOTAL_PRICE);
        openapiFields.add(SERIALIZED_NAME_CURRENCY);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!Email.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Email.class));
            return new TypeAdapter<Email>(){

                public void write(JsonWriter out, Email value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public Email read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Email.validateJsonObject(jsonObj);
                    Email instance = (Email)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

