/*
 * Decompiled with CFR 0.152.
 */
package com.ycloud.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ycloud.client.JSON;
import com.ycloud.client.model.EmailContentType;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EmailSendRequest {
    public static final String SERIALIZED_NAME_FROM = "from";
    @SerializedName(value="from")
    private String from;
    public static final String SERIALIZED_NAME_TO = "to";
    @SerializedName(value="to")
    private String to;
    public static final String SERIALIZED_NAME_SUBJECT = "subject";
    @SerializedName(value="subject")
    private String subject;
    public static final String SERIALIZED_NAME_CONTENT = "content";
    @SerializedName(value="content")
    private String content;
    public static final String SERIALIZED_NAME_CONTENT_TYPE = "contentType";
    @SerializedName(value="contentType")
    private EmailContentType contentType;
    public static final String SERIALIZED_NAME_VARIABLES = "variables";
    @SerializedName(value="variables")
    private List<Map<String, String>> variables = null;
    public static final String SERIALIZED_NAME_CC = "cc";
    @SerializedName(value="cc")
    private String cc;
    public static final String SERIALIZED_NAME_BCC = "bcc";
    @SerializedName(value="bcc")
    private String bcc;
    public static final String SERIALIZED_NAME_REPLY_TO = "replyTo";
    @SerializedName(value="replyTo")
    private String replyTo;
    public static final String SERIALIZED_NAME_SUMMARY = "summary";
    @SerializedName(value="summary")
    private String summary;
    public static final String SERIALIZED_NAME_EXTERNAL_ID = "externalId";
    @SerializedName(value="externalId")
    private String externalId;
    public static final String SERIALIZED_NAME_CALLBACK_URL = "callbackUrl";
    @SerializedName(value="callbackUrl")
    private String callbackUrl;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public EmailSendRequest from(String from) {
        this.from = from;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="YCloud<ycloud@ycloud-mail.com>", required=true, value="- The sender's email. Its domain should be one that has been registered and activated in your YCloud account. - The test address provided by YCloud is `ycloud@ycloud-mail.com`, which only supports sending emails to your registered email address. - The sender's email address is required while the sender's name is optional. For example, both `ycloud@ycloud-mail.com` and `YCloud<ycloud@ycloud-mail.com>` work.")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public EmailSendRequest to(String to) {
        this.to = to;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="to1@example.com,Nick<to2@example.com>", required=true, value="- The intended recipients' email addresses. - Supports a comma-separated list of one or more addresses. Max items: 100.")
    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public EmailSendRequest subject(String subject) {
        this.subject = subject;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The email subject, which contains a short string identifying the topic of the message. Max length: 255.")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public EmailSendRequest content(String content) {
        this.content = content;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="This is a test message from #nick#.", required=true, value="- The email body. Max size: 150 KB. - Variables in the form of `#var_1#` are supported, they should be used together with the `variables` parameter. Variable keys only support letters, digits, and the underline character (`_`). - You can use the [Test Templates](https://help.ycloud.com/en/articles/6006545) provided by YCloud for testing.")
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public EmailSendRequest contentType(EmailContentType contentType) {
        this.contentType = contentType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public EmailContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(EmailContentType contentType) {
        this.contentType = contentType;
    }

    public EmailSendRequest variables(List<Map<String, String>> variables) {
        this.variables = variables;
        return this;
    }

    public EmailSendRequest addVariablesItem(Map<String, String> variablesItem) {
        if (this.variables == null) {
            this.variables = new ArrayList<Map<String, String>>();
        }
        this.variables.add(variablesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="- The variable key-value pairs that will replace the variable placeholders in `content` for each recipient. Variable keys are those that are wrapped with `#` as placeholders (e.g., `#var_1#`) in `content`. The placeholders will be replaced by variable values when sending the email. - The size of the array must be the same as the number of recipients in `to`. Be aware that `cc` and `bcc` addresses are excluded, and they can not receive emails that contain variables. - This parameter's size will be calculated together with the parameter `content`. The whole size must not exceed 150 KB.")
    public List<Map<String, String>> getVariables() {
        return this.variables;
    }

    public void setVariables(List<Map<String, String>> variables) {
        this.variables = variables;
    }

    public EmailSendRequest cc(String cc) {
        this.cc = cc;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="cc1@example.com,Nick<cc2@example.com>", value="Recipients who will receive a copy of the email.")
    public String getCc() {
        return this.cc;
    }

    public void setCc(String cc) {
        this.cc = cc;
    }

    public EmailSendRequest bcc(String bcc) {
        this.bcc = bcc;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="bcc1@example.com,Nick<bcc2@example.com>", value="Recipients who will receive a blind carbon copy of the email.")
    public String getBcc() {
        return this.bcc;
    }

    public void setBcc(String bcc) {
        this.bcc = bcc;
    }

    public EmailSendRequest replyTo(String replyTo) {
        this.replyTo = replyTo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If this field exists, then the reply should go to the addresses indicated in that field and not to the address(es) indicated in the `from` field.")
    public String getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public EmailSendRequest summary(String summary) {
        this.summary = summary;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="This is a summary.", value="This is a summary of your email. Max length: 70.")
    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public EmailSendRequest externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A unique string to reference the object. This can be an order number or similar, and can be used to reconcile the object with your internal systems.")
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public EmailSendRequest callbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://httpbin.org/anything?tag=api-email", value="Delivery report URL. You can provide a URL, and we will push the updated status report to your server in time. e.g., https://httpbin.org/anything?tag=api. Note: We recommend configuring Webhook Endpoints instead.")
    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public EmailSendRequest putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmailSendRequest emailSendRequest = (EmailSendRequest)o;
        return Objects.equals(this.from, emailSendRequest.from) && Objects.equals(this.to, emailSendRequest.to) && Objects.equals(this.subject, emailSendRequest.subject) && Objects.equals(this.content, emailSendRequest.content) && Objects.equals((Object)this.contentType, (Object)emailSendRequest.contentType) && Objects.equals(this.variables, emailSendRequest.variables) && Objects.equals(this.cc, emailSendRequest.cc) && Objects.equals(this.bcc, emailSendRequest.bcc) && Objects.equals(this.replyTo, emailSendRequest.replyTo) && Objects.equals(this.summary, emailSendRequest.summary) && Objects.equals(this.externalId, emailSendRequest.externalId) && Objects.equals(this.callbackUrl, emailSendRequest.callbackUrl) && Objects.equals(this.additionalProperties, emailSendRequest.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.from, this.to, this.subject, this.content, this.contentType, this.variables, this.cc, this.bcc, this.replyTo, this.summary, this.externalId, this.callbackUrl, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmailSendRequest {\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString((Object)this.contentType)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("    cc: ").append(this.toIndentedString(this.cc)).append("\n");
        sb.append("    bcc: ").append(this.toIndentedString(this.bcc)).append("\n");
        sb.append("    replyTo: ").append(this.toIndentedString(this.replyTo)).append("\n");
        sb.append("    summary: ").append(this.toIndentedString(this.summary)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    callbackUrl: ").append(this.toIndentedString(this.callbackUrl)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in EmailSendRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FROM) != null && !jsonObj.get(SERIALIZED_NAME_FROM).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `from` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FROM).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TO) != null && !jsonObj.get(SERIALIZED_NAME_TO).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `to` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TO).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUBJECT) != null && !jsonObj.get(SERIALIZED_NAME_SUBJECT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `subject` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUBJECT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONTENT) != null && !jsonObj.get(SERIALIZED_NAME_CONTENT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `content` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTENT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VARIABLES) != null && !jsonObj.get(SERIALIZED_NAME_VARIABLES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `variables` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VARIABLES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CC) != null && !jsonObj.get(SERIALIZED_NAME_CC).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `cc` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CC).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BCC) != null && !jsonObj.get(SERIALIZED_NAME_BCC).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `bcc` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BCC).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REPLY_TO) != null && !jsonObj.get(SERIALIZED_NAME_REPLY_TO).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `replyTo` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REPLY_TO).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUMMARY) != null && !jsonObj.get(SERIALIZED_NAME_SUMMARY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `summary` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUMMARY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXTERNAL_ID) != null && !jsonObj.get(SERIALIZED_NAME_EXTERNAL_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `externalId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXTERNAL_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CALLBACK_URL) != null && !jsonObj.get(SERIALIZED_NAME_CALLBACK_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `callbackUrl` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CALLBACK_URL).toString()));
        }
    }

    public static EmailSendRequest fromJson(String jsonString) throws IOException {
        return (EmailSendRequest)JSON.getGson().fromJson(jsonString, EmailSendRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_FROM);
        openapiFields.add(SERIALIZED_NAME_TO);
        openapiFields.add(SERIALIZED_NAME_SUBJECT);
        openapiFields.add(SERIALIZED_NAME_CONTENT);
        openapiFields.add(SERIALIZED_NAME_CONTENT_TYPE);
        openapiFields.add(SERIALIZED_NAME_VARIABLES);
        openapiFields.add(SERIALIZED_NAME_CC);
        openapiFields.add(SERIALIZED_NAME_BCC);
        openapiFields.add(SERIALIZED_NAME_REPLY_TO);
        openapiFields.add(SERIALIZED_NAME_SUMMARY);
        openapiFields.add(SERIALIZED_NAME_EXTERNAL_ID);
        openapiFields.add(SERIALIZED_NAME_CALLBACK_URL);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_FROM);
        openapiRequiredFields.add(SERIALIZED_NAME_TO);
        openapiRequiredFields.add(SERIALIZED_NAME_SUBJECT);
        openapiRequiredFields.add(SERIALIZED_NAME_CONTENT);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!EmailSendRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(EmailSendRequest.class));
            return new TypeAdapter<EmailSendRequest>(){

                public void write(JsonWriter out, EmailSendRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public EmailSendRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    EmailSendRequest.validateJsonObject(jsonObj);
                    EmailSendRequest instance = (EmailSendRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

