/*
 * Decompiled with CFR 0.152.
 */
package com.ycloud.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ycloud.client.JSON;
import com.ycloud.client.model.EmailDelivery;
import com.ycloud.client.model.EventType;
import com.ycloud.client.model.Sms;
import com.ycloud.client.model.Voice;
import com.ycloud.client.model.WhatsappBusinessAccount;
import com.ycloud.client.model.WhatsappInboundMessage;
import com.ycloud.client.model.WhatsappMessage;
import com.ycloud.client.model.WhatsappPhoneNumber;
import com.ycloud.client.model.WhatsappTemplate;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Represents a webhook event payload. Every event contains certain common properties: `id`, `type`, `apiVersion`, `createTime`. Each event may also contain some properties unique to the event. For example, `sms` is returned when `type` is `sms.message.updated`.")
public class Event {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private EventType type;
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    private String apiVersion;
    public static final String SERIALIZED_NAME_CREATE_TIME = "createTime";
    @SerializedName(value="createTime")
    private Date createTime;
    public static final String SERIALIZED_NAME_EMAIL_DELIVERY = "emailDelivery";
    @SerializedName(value="emailDelivery")
    private EmailDelivery emailDelivery;
    public static final String SERIALIZED_NAME_SMS = "sms";
    @SerializedName(value="sms")
    private Sms sms;
    public static final String SERIALIZED_NAME_VOICE = "voice";
    @SerializedName(value="voice")
    private Voice voice;
    public static final String SERIALIZED_NAME_WHATSAPP_BUSINESS_ACCOUNT = "whatsappBusinessAccount";
    @SerializedName(value="whatsappBusinessAccount")
    private WhatsappBusinessAccount whatsappBusinessAccount;
    public static final String SERIALIZED_NAME_WHATSAPP_INBOUND_MESSAGE = "whatsappInboundMessage";
    @SerializedName(value="whatsappInboundMessage")
    private WhatsappInboundMessage whatsappInboundMessage;
    public static final String SERIALIZED_NAME_WHATSAPP_MESSAGE = "whatsappMessage";
    @SerializedName(value="whatsappMessage")
    private WhatsappMessage whatsappMessage;
    public static final String SERIALIZED_NAME_WHATSAPP_PHONE_NUMBER = "whatsappPhoneNumber";
    @SerializedName(value="whatsappPhoneNumber")
    private WhatsappPhoneNumber whatsappPhoneNumber;
    public static final String SERIALIZED_NAME_WHATSAPP_TEMPLATE = "whatsappTemplate";
    @SerializedName(value="whatsappTemplate")
    private WhatsappTemplate whatsappTemplate;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Event id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Unique ID for the object.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Event type(EventType type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public EventType getType() {
        return this.type;
    }

    public void setType(EventType type) {
        this.type = type;
    }

    public Event apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="v2", required=true, value="The API version used to render this event.")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public Event createTime(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="2022-06-01T12:00Z", required=true, value="The time at which this event was created, formatted in [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339). e.g., `2022-06-01T12:00:00.000Z`.")
    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Event emailDelivery(EmailDelivery emailDelivery) {
        this.emailDelivery = emailDelivery;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public EmailDelivery getEmailDelivery() {
        return this.emailDelivery;
    }

    public void setEmailDelivery(EmailDelivery emailDelivery) {
        this.emailDelivery = emailDelivery;
    }

    public Event sms(Sms sms) {
        this.sms = sms;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Sms getSms() {
        return this.sms;
    }

    public void setSms(Sms sms) {
        this.sms = sms;
    }

    public Event voice(Voice voice) {
        this.voice = voice;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Voice getVoice() {
        return this.voice;
    }

    public void setVoice(Voice voice) {
        this.voice = voice;
    }

    public Event whatsappBusinessAccount(WhatsappBusinessAccount whatsappBusinessAccount) {
        this.whatsappBusinessAccount = whatsappBusinessAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappBusinessAccount getWhatsappBusinessAccount() {
        return this.whatsappBusinessAccount;
    }

    public void setWhatsappBusinessAccount(WhatsappBusinessAccount whatsappBusinessAccount) {
        this.whatsappBusinessAccount = whatsappBusinessAccount;
    }

    public Event whatsappInboundMessage(WhatsappInboundMessage whatsappInboundMessage) {
        this.whatsappInboundMessage = whatsappInboundMessage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappInboundMessage getWhatsappInboundMessage() {
        return this.whatsappInboundMessage;
    }

    public void setWhatsappInboundMessage(WhatsappInboundMessage whatsappInboundMessage) {
        this.whatsappInboundMessage = whatsappInboundMessage;
    }

    public Event whatsappMessage(WhatsappMessage whatsappMessage) {
        this.whatsappMessage = whatsappMessage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappMessage getWhatsappMessage() {
        return this.whatsappMessage;
    }

    public void setWhatsappMessage(WhatsappMessage whatsappMessage) {
        this.whatsappMessage = whatsappMessage;
    }

    public Event whatsappPhoneNumber(WhatsappPhoneNumber whatsappPhoneNumber) {
        this.whatsappPhoneNumber = whatsappPhoneNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappPhoneNumber getWhatsappPhoneNumber() {
        return this.whatsappPhoneNumber;
    }

    public void setWhatsappPhoneNumber(WhatsappPhoneNumber whatsappPhoneNumber) {
        this.whatsappPhoneNumber = whatsappPhoneNumber;
    }

    public Event whatsappTemplate(WhatsappTemplate whatsappTemplate) {
        this.whatsappTemplate = whatsappTemplate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappTemplate getWhatsappTemplate() {
        return this.whatsappTemplate;
    }

    public void setWhatsappTemplate(WhatsappTemplate whatsappTemplate) {
        this.whatsappTemplate = whatsappTemplate;
    }

    public Event putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event event = (Event)o;
        return Objects.equals(this.id, event.id) && Objects.equals((Object)this.type, (Object)event.type) && Objects.equals(this.apiVersion, event.apiVersion) && Objects.equals(this.createTime, event.createTime) && Objects.equals(this.emailDelivery, event.emailDelivery) && Objects.equals(this.sms, event.sms) && Objects.equals(this.voice, event.voice) && Objects.equals(this.whatsappBusinessAccount, event.whatsappBusinessAccount) && Objects.equals(this.whatsappInboundMessage, event.whatsappInboundMessage) && Objects.equals(this.whatsappMessage, event.whatsappMessage) && Objects.equals(this.whatsappPhoneNumber, event.whatsappPhoneNumber) && Objects.equals(this.whatsappTemplate, event.whatsappTemplate) && Objects.equals(this.additionalProperties, event.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.type, this.apiVersion, this.createTime, this.emailDelivery, this.sms, this.voice, this.whatsappBusinessAccount, this.whatsappInboundMessage, this.whatsappMessage, this.whatsappPhoneNumber, this.whatsappTemplate, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Event {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    createTime: ").append(this.toIndentedString(this.createTime)).append("\n");
        sb.append("    emailDelivery: ").append(this.toIndentedString(this.emailDelivery)).append("\n");
        sb.append("    sms: ").append(this.toIndentedString(this.sms)).append("\n");
        sb.append("    voice: ").append(this.toIndentedString(this.voice)).append("\n");
        sb.append("    whatsappBusinessAccount: ").append(this.toIndentedString(this.whatsappBusinessAccount)).append("\n");
        sb.append("    whatsappInboundMessage: ").append(this.toIndentedString(this.whatsappInboundMessage)).append("\n");
        sb.append("    whatsappMessage: ").append(this.toIndentedString(this.whatsappMessage)).append("\n");
        sb.append("    whatsappPhoneNumber: ").append(this.toIndentedString(this.whatsappPhoneNumber)).append("\n");
        sb.append("    whatsappTemplate: ").append(this.toIndentedString(this.whatsappTemplate)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Event is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_API_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_API_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `apiVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_API_VERSION).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_EMAIL_DELIVERY) != null) {
            EmailDelivery.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_EMAIL_DELIVERY));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SMS) != null) {
            Sms.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SMS));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_VOICE) != null) {
            Voice.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_VOICE));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_WHATSAPP_BUSINESS_ACCOUNT) != null) {
            WhatsappBusinessAccount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_WHATSAPP_BUSINESS_ACCOUNT));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_WHATSAPP_INBOUND_MESSAGE) != null) {
            WhatsappInboundMessage.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_WHATSAPP_INBOUND_MESSAGE));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_WHATSAPP_MESSAGE) != null) {
            WhatsappMessage.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_WHATSAPP_MESSAGE));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_WHATSAPP_PHONE_NUMBER) != null) {
            WhatsappPhoneNumber.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_WHATSAPP_PHONE_NUMBER));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_WHATSAPP_TEMPLATE) != null) {
            WhatsappTemplate.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_WHATSAPP_TEMPLATE));
        }
    }

    public static Event fromJson(String jsonString) throws IOException {
        return (Event)JSON.getGson().fromJson(jsonString, Event.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_API_VERSION);
        openapiFields.add(SERIALIZED_NAME_CREATE_TIME);
        openapiFields.add(SERIALIZED_NAME_EMAIL_DELIVERY);
        openapiFields.add(SERIALIZED_NAME_SMS);
        openapiFields.add(SERIALIZED_NAME_VOICE);
        openapiFields.add(SERIALIZED_NAME_WHATSAPP_BUSINESS_ACCOUNT);
        openapiFields.add(SERIALIZED_NAME_WHATSAPP_INBOUND_MESSAGE);
        openapiFields.add(SERIALIZED_NAME_WHATSAPP_MESSAGE);
        openapiFields.add(SERIALIZED_NAME_WHATSAPP_PHONE_NUMBER);
        openapiFields.add(SERIALIZED_NAME_WHATSAPP_TEMPLATE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_API_VERSION);
        openapiRequiredFields.add(SERIALIZED_NAME_CREATE_TIME);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!Event.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Event.class));
            return new TypeAdapter<Event>(){

                public void write(JsonWriter out, Event value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public Event read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Event.validateJsonObject(jsonObj);
                    Event instance = (Event)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

