/*
 * Decompiled with CFR 0.152.
 */
package com.ycloud.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ycloud.client.JSON;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SmsSendRequest {
    public static final String SERIALIZED_NAME_TO = "to";
    @SerializedName(value="to")
    private String to;
    public static final String SERIALIZED_NAME_TEXT = "text";
    @SerializedName(value="text")
    private String text;
    public static final String SERIALIZED_NAME_SENDER_ID = "senderId";
    @SerializedName(value="senderId")
    private String senderId;
    public static final String SERIALIZED_NAME_SIGNATURE = "signature";
    @SerializedName(value="signature")
    private String signature;
    public static final String SERIALIZED_NAME_EXTERNAL_ID = "externalId";
    @SerializedName(value="externalId")
    private String externalId;
    public static final String SERIALIZED_NAME_CALLBACK_URL = "callbackUrl";
    @SerializedName(value="callbackUrl")
    private String callbackUrl;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public SmsSendRequest to(String to) {
        this.to = to;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="+447901614024", required=true, value="The recipient's phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format.")
    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public SmsSendRequest text(String text) {
        this.text = text;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="Your verification code is 123456.", required=true, value="The text of this message.")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public SmsSendRequest senderId(String senderId) {
        this.senderId = senderId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="YCloud", value="[Sender ID](https://help.ycloud.com/en/articles/3080386) to be used.")
    public String getSenderId() {
        return this.senderId;
    }

    public void setSenderId(String senderId) {
        this.senderId = senderId;
    }

    public SmsSendRequest signature(String signature) {
        this.signature = signature;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="YCloud", value="This parameter is only required for Chinese mainland SMS messages. You must specify an approved signature such as `YCloud`. It will be added to the beginning of SMS body and wrapped with `\u3010\u3011`, e.g. `\u3010YCloud\u3011Your verification code is 123456`.")
    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public SmsSendRequest externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A unique string to reference the object. This can be an order number or similar, and can be used to reconcile the object with your internal systems.")
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public SmsSendRequest callbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://httpbin.org/anything?tag=api-sms", value="Delivery report URL. You can provide a URL, and we will push the updated status report to your server in time. e.g., https://httpbin.org/anything?tag=api. Note: We recommend configuring Webhook Endpoints instead.")
    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public SmsSendRequest putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SmsSendRequest smsSendRequest = (SmsSendRequest)o;
        return Objects.equals(this.to, smsSendRequest.to) && Objects.equals(this.text, smsSendRequest.text) && Objects.equals(this.senderId, smsSendRequest.senderId) && Objects.equals(this.signature, smsSendRequest.signature) && Objects.equals(this.externalId, smsSendRequest.externalId) && Objects.equals(this.callbackUrl, smsSendRequest.callbackUrl) && Objects.equals(this.additionalProperties, smsSendRequest.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.to, this.text, this.senderId, this.signature, this.externalId, this.callbackUrl, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SmsSendRequest {\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    senderId: ").append(this.toIndentedString(this.senderId)).append("\n");
        sb.append("    signature: ").append(this.toIndentedString(this.signature)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    callbackUrl: ").append(this.toIndentedString(this.callbackUrl)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in SmsSendRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TO) != null && !jsonObj.get(SERIALIZED_NAME_TO).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `to` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TO).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TEXT) != null && !jsonObj.get(SERIALIZED_NAME_TEXT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `text` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TEXT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SENDER_ID) != null && !jsonObj.get(SERIALIZED_NAME_SENDER_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `senderId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SENDER_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SIGNATURE) != null && !jsonObj.get(SERIALIZED_NAME_SIGNATURE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `signature` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SIGNATURE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXTERNAL_ID) != null && !jsonObj.get(SERIALIZED_NAME_EXTERNAL_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `externalId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXTERNAL_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CALLBACK_URL) != null && !jsonObj.get(SERIALIZED_NAME_CALLBACK_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `callbackUrl` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CALLBACK_URL).toString()));
        }
    }

    public static SmsSendRequest fromJson(String jsonString) throws IOException {
        return (SmsSendRequest)JSON.getGson().fromJson(jsonString, SmsSendRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_TO);
        openapiFields.add(SERIALIZED_NAME_TEXT);
        openapiFields.add(SERIALIZED_NAME_SENDER_ID);
        openapiFields.add(SERIALIZED_NAME_SIGNATURE);
        openapiFields.add(SERIALIZED_NAME_EXTERNAL_ID);
        openapiFields.add(SERIALIZED_NAME_CALLBACK_URL);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_TO);
        openapiRequiredFields.add(SERIALIZED_NAME_TEXT);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!SmsSendRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(SmsSendRequest.class));
            return new TypeAdapter<SmsSendRequest>(){

                public void write(JsonWriter out, SmsSendRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public SmsSendRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    SmsSendRequest.validateJsonObject(jsonObj);
                    SmsSendRequest instance = (SmsSendRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

