/*
 * Decompiled with CFR 0.152.
 */
package com.ycloud.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ycloud.client.JSON;
import com.ycloud.client.model.VerificationChannel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class VerificationSendRequest {
    public static final String SERIALIZED_NAME_CHANNEL = "channel";
    @SerializedName(value="channel")
    private VerificationChannel channel;
    public static final String SERIALIZED_NAME_TO = "to";
    @SerializedName(value="to")
    private String to;
    public static final String SERIALIZED_NAME_CODE = "code";
    @SerializedName(value="code")
    private String code;
    public static final String SERIALIZED_NAME_SENDER_ID = "senderId";
    @SerializedName(value="senderId")
    private String senderId;
    public static final String SERIALIZED_NAME_SIGNATURE = "signature";
    @SerializedName(value="signature")
    private String signature;
    public static final String SERIALIZED_NAME_LANGUAGE = "language";
    @SerializedName(value="language")
    private String language;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public VerificationSendRequest channel(VerificationChannel channel) {
        this.channel = channel;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public VerificationChannel getChannel() {
        return this.channel;
    }

    public void setChannel(VerificationChannel channel) {
        this.channel = channel;
    }

    public VerificationSendRequest to(String to) {
        this.to = to;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="+447901614024", required=true, value="The recipient's phone number or email address depending on `channel`. - Phone number: In [E.164](https://en.wikipedia.org/wiki/E.164) format. Applicable when `channel` is `sms` or `voice`. - Email address: For example, `tom@example.com`. Applicable when `channel` is `email_code`.")
    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public VerificationSendRequest code(String code) {
        this.code = code;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="123456", value="Verification code to be sent. This field is optional. If not provided, YCloud will automatically generate a code.")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public VerificationSendRequest senderId(String senderId) {
        this.senderId = senderId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="YCloud", value="[Sender ID](https://help.ycloud.com/en/articles/3080386) to be used.")
    public String getSenderId() {
        return this.senderId;
    }

    public void setSenderId(String senderId) {
        this.senderId = senderId;
    }

    public VerificationSendRequest signature(String signature) {
        this.signature = signature;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="YCloud", value="This parameter is only required for Chinese mainland SMS messages. You must specify an approved signature such as `YCloud`. It will be added to the beginning of SMS body and wrapped with `\u3010\u3011`, e.g. `\u3010YCloud\u3011Your verification code is 123456`.")
    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public VerificationSendRequest language(String language) {
        this.language = language;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="en", value="[ISO 639 Language Code](https://www.iso.org/iso-639-language-codes.html). If not specified, language will be set as `en` by default. Notably, in certain countries or regions, language will be automatically set as the local language due to the regional restrictions. Applicable languages: `ar`: Arabic `de`: German `en`: English `es`: Spanish `fr`: French `id`: Indonesian `it`: Italian `pt_BR`: Portuguese. Not applicable when `channel` is `whatsapp`. `ru`: Russian `tr`: Turkish `vi`: Vietnamese `zh_CN`: Simplified Chinese `zh_HK`: Traditional Chinese")
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public VerificationSendRequest putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerificationSendRequest verificationSendRequest = (VerificationSendRequest)o;
        return Objects.equals((Object)this.channel, (Object)verificationSendRequest.channel) && Objects.equals(this.to, verificationSendRequest.to) && Objects.equals(this.code, verificationSendRequest.code) && Objects.equals(this.senderId, verificationSendRequest.senderId) && Objects.equals(this.signature, verificationSendRequest.signature) && Objects.equals(this.language, verificationSendRequest.language) && Objects.equals(this.additionalProperties, verificationSendRequest.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.channel, this.to, this.code, this.senderId, this.signature, this.language, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VerificationSendRequest {\n");
        sb.append("    channel: ").append(this.toIndentedString((Object)this.channel)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    senderId: ").append(this.toIndentedString(this.senderId)).append("\n");
        sb.append("    signature: ").append(this.toIndentedString(this.signature)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in VerificationSendRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TO) != null && !jsonObj.get(SERIALIZED_NAME_TO).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `to` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TO).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CODE) != null && !jsonObj.get(SERIALIZED_NAME_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `code` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SENDER_ID) != null && !jsonObj.get(SERIALIZED_NAME_SENDER_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `senderId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SENDER_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SIGNATURE) != null && !jsonObj.get(SERIALIZED_NAME_SIGNATURE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `signature` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SIGNATURE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LANGUAGE) != null && !jsonObj.get(SERIALIZED_NAME_LANGUAGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `language` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LANGUAGE).toString()));
        }
    }

    public static VerificationSendRequest fromJson(String jsonString) throws IOException {
        return (VerificationSendRequest)JSON.getGson().fromJson(jsonString, VerificationSendRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CHANNEL);
        openapiFields.add(SERIALIZED_NAME_TO);
        openapiFields.add(SERIALIZED_NAME_CODE);
        openapiFields.add(SERIALIZED_NAME_SENDER_ID);
        openapiFields.add(SERIALIZED_NAME_SIGNATURE);
        openapiFields.add(SERIALIZED_NAME_LANGUAGE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_CHANNEL);
        openapiRequiredFields.add(SERIALIZED_NAME_TO);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!VerificationSendRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(VerificationSendRequest.class));
            return new TypeAdapter<VerificationSendRequest>(){

                public void write(JsonWriter out, VerificationSendRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public VerificationSendRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    VerificationSendRequest.validateJsonObject(jsonObj);
                    VerificationSendRequest instance = (VerificationSendRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

