/*
 * Decompiled with CFR 0.152.
 */
package com.ycloud.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ycloud.client.JSON;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class VoiceSendRequest {
    public static final String SERIALIZED_NAME_TO = "to";
    @SerializedName(value="to")
    private String to;
    public static final String SERIALIZED_NAME_VERIFICATION_CODE = "verificationCode";
    @SerializedName(value="verificationCode")
    private String verificationCode;
    public static final String SERIALIZED_NAME_LANGUAGE = "language";
    @SerializedName(value="language")
    private String language;
    public static final String SERIALIZED_NAME_EXTERNAL_ID = "externalId";
    @SerializedName(value="externalId")
    private String externalId;
    public static final String SERIALIZED_NAME_CALLBACK_URL = "callbackUrl";
    @SerializedName(value="callbackUrl")
    private String callbackUrl;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public VoiceSendRequest to(String to) {
        this.to = to;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="+447901614024", required=true, value="The recipient's phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format.")
    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public VoiceSendRequest verificationCode(String verificationCode) {
        this.verificationCode = verificationCode;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="123456", required=true, value="The verification code to be sent, 4 to 6 digits.")
    public String getVerificationCode() {
        return this.verificationCode;
    }

    public void setVerificationCode(String verificationCode) {
        this.verificationCode = verificationCode;
    }

    public VoiceSendRequest language(String language) {
        this.language = language;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="en", value="[ISO 639 Language Code](https://www.iso.org/iso-639-language-codes.html). If not specified, language will be set as `en` by default. Notably, in certain countries or regions, language will be automatically set as the local language due to the regional restrictions. Applicable languages: `ar`: Arabic `de`: German `en`: English `es`: Spanish `fr`: French `id`: Indonesian `it`: Italian `pt`: Portuguese `ru`: Russian `tr`: Turkish `vi`: Vietnamese `zh`: Chinese")
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public VoiceSendRequest externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A unique string to reference the object. This can be an order number or similar, and can be used to reconcile the object with your internal systems.")
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public VoiceSendRequest callbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://httpbin.org/anything?tag=api-voice", value="Delivery report URL. You can provide a URL, and we will push the updated status report to your server in time. e.g., https://httpbin.org/anything?tag=api. Note: We recommend configuring Webhook Endpoints instead.")
    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public VoiceSendRequest putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VoiceSendRequest voiceSendRequest = (VoiceSendRequest)o;
        return Objects.equals(this.to, voiceSendRequest.to) && Objects.equals(this.verificationCode, voiceSendRequest.verificationCode) && Objects.equals(this.language, voiceSendRequest.language) && Objects.equals(this.externalId, voiceSendRequest.externalId) && Objects.equals(this.callbackUrl, voiceSendRequest.callbackUrl) && Objects.equals(this.additionalProperties, voiceSendRequest.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.to, this.verificationCode, this.language, this.externalId, this.callbackUrl, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VoiceSendRequest {\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    verificationCode: ").append(this.toIndentedString(this.verificationCode)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    callbackUrl: ").append(this.toIndentedString(this.callbackUrl)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in VoiceSendRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TO) != null && !jsonObj.get(SERIALIZED_NAME_TO).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `to` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TO).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VERIFICATION_CODE) != null && !jsonObj.get(SERIALIZED_NAME_VERIFICATION_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `verificationCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VERIFICATION_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LANGUAGE) != null && !jsonObj.get(SERIALIZED_NAME_LANGUAGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `language` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LANGUAGE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXTERNAL_ID) != null && !jsonObj.get(SERIALIZED_NAME_EXTERNAL_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `externalId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXTERNAL_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CALLBACK_URL) != null && !jsonObj.get(SERIALIZED_NAME_CALLBACK_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `callbackUrl` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CALLBACK_URL).toString()));
        }
    }

    public static VoiceSendRequest fromJson(String jsonString) throws IOException {
        return (VoiceSendRequest)JSON.getGson().fromJson(jsonString, VoiceSendRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_TO);
        openapiFields.add(SERIALIZED_NAME_VERIFICATION_CODE);
        openapiFields.add(SERIALIZED_NAME_LANGUAGE);
        openapiFields.add(SERIALIZED_NAME_EXTERNAL_ID);
        openapiFields.add(SERIALIZED_NAME_CALLBACK_URL);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_TO);
        openapiRequiredFields.add(SERIALIZED_NAME_VERIFICATION_CODE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!VoiceSendRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(VoiceSendRequest.class));
            return new TypeAdapter<VoiceSendRequest>(){

                public void write(JsonWriter out, VoiceSendRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public VoiceSendRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    VoiceSendRequest.validateJsonObject(jsonObj);
                    VoiceSendRequest instance = (VoiceSendRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

