/*
 * Decompiled with CFR 0.152.
 */
package com.ycloud.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ycloud.client.JSON;
import com.ycloud.client.model.EventType;
import com.ycloud.client.model.WebhookEndpointStatus;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WebhookEndpointCreateRequest {
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    private String url;
    public static final String SERIALIZED_NAME_ENABLED_EVENTS = "enabledEvents";
    @SerializedName(value="enabledEvents")
    private List<EventType> enabledEvents = new ArrayList<EventType>();
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private WebhookEndpointStatus status;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public WebhookEndpointCreateRequest url(String url) {
        this.url = url;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="https://httpbin.org/anything?tag=api", required=true, value="The URL of the webhook endpoint.")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public WebhookEndpointCreateRequest enabledEvents(List<EventType> enabledEvents) {
        this.enabledEvents = enabledEvents;
        return this;
    }

    public WebhookEndpointCreateRequest addEnabledEventsItem(EventType enabledEventsItem) {
        this.enabledEvents.add(enabledEventsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The list of events to enable for this endpoint.")
    public List<EventType> getEnabledEvents() {
        return this.enabledEvents;
    }

    public void setEnabledEvents(List<EventType> enabledEvents) {
        this.enabledEvents = enabledEvents;
    }

    public WebhookEndpointCreateRequest description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="My first webhook endpoint.", value="An optional description of what the webhook is used for.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public WebhookEndpointCreateRequest status(WebhookEndpointStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WebhookEndpointStatus getStatus() {
        return this.status;
    }

    public void setStatus(WebhookEndpointStatus status) {
        this.status = status;
    }

    public WebhookEndpointCreateRequest putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebhookEndpointCreateRequest webhookEndpointCreateRequest = (WebhookEndpointCreateRequest)o;
        return Objects.equals(this.url, webhookEndpointCreateRequest.url) && Objects.equals(this.enabledEvents, webhookEndpointCreateRequest.enabledEvents) && Objects.equals(this.description, webhookEndpointCreateRequest.description) && Objects.equals((Object)this.status, (Object)webhookEndpointCreateRequest.status) && Objects.equals(this.additionalProperties, webhookEndpointCreateRequest.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.url, this.enabledEvents, this.description, this.status, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebhookEndpointCreateRequest {\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    enabledEvents: ").append(this.toIndentedString(this.enabledEvents)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in WebhookEndpointCreateRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_URL) != null && !jsonObj.get(SERIALIZED_NAME_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `url` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_URL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENABLED_EVENTS) != null && !jsonObj.get(SERIALIZED_NAME_ENABLED_EVENTS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `enabledEvents` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENABLED_EVENTS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
    }

    public static WebhookEndpointCreateRequest fromJson(String jsonString) throws IOException {
        return (WebhookEndpointCreateRequest)JSON.getGson().fromJson(jsonString, WebhookEndpointCreateRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_URL);
        openapiFields.add(SERIALIZED_NAME_ENABLED_EVENTS);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_URL);
        openapiRequiredFields.add(SERIALIZED_NAME_ENABLED_EVENTS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!WebhookEndpointCreateRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(WebhookEndpointCreateRequest.class));
            return new TypeAdapter<WebhookEndpointCreateRequest>(){

                public void write(JsonWriter out, WebhookEndpointCreateRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public WebhookEndpointCreateRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    WebhookEndpointCreateRequest.validateJsonObject(jsonObj);
                    WebhookEndpointCreateRequest instance = (WebhookEndpointCreateRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

