/*
 * Decompiled with CFR 0.152.
 */
package com.ycloud.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ycloud.client.JSON;
import com.ycloud.client.model.MetaBusinessAccountVerificationStatus;
import com.ycloud.client.model.WhatsappBusinessAccountBanState;
import com.ycloud.client.model.WhatsappBusinessAccountRestrictionInfo;
import com.ycloud.client.model.WhatsappBusinessAccountReviewStatus;
import com.ycloud.client.model.WhatsappBusinessAccountUpdateEventEnum;
import com.ycloud.client.model.WhatsappReviewDecision;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Represents a specific [WhatsApp Business Account (WABA)](https://www.facebook.com/business/help/1499554293524119).")
public class WhatsappBusinessAccount {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_MESSAGE_TEMPLATE_NAMESPACE = "messageTemplateNamespace";
    @SerializedName(value="messageTemplateNamespace")
    private String messageTemplateNamespace;
    public static final String SERIALIZED_NAME_ACCOUNT_REVIEW_STATUS = "accountReviewStatus";
    @SerializedName(value="accountReviewStatus")
    private WhatsappBusinessAccountReviewStatus accountReviewStatus;
    public static final String SERIALIZED_NAME_BUSINESS_VERIFICATION_STATUS = "businessVerificationStatus";
    @SerializedName(value="businessVerificationStatus")
    private MetaBusinessAccountVerificationStatus businessVerificationStatus;
    public static final String SERIALIZED_NAME_COUNTRY = "country";
    @SerializedName(value="country")
    private String country;
    public static final String SERIALIZED_NAME_OWNERSHIP_TYPE = "ownershipType";
    @SerializedName(value="ownershipType")
    private String ownershipType;
    public static final String SERIALIZED_NAME_PRIMARY_FUNDING_ID = "primaryFundingId";
    @SerializedName(value="primaryFundingId")
    private String primaryFundingId;
    public static final String SERIALIZED_NAME_PURCHASE_ORDER_NUMBER = "purchaseOrderNumber";
    @SerializedName(value="purchaseOrderNumber")
    private String purchaseOrderNumber;
    public static final String SERIALIZED_NAME_TIMEZONE_ID = "timezoneId";
    @SerializedName(value="timezoneId")
    private String timezoneId;
    public static final String SERIALIZED_NAME_DECISION = "decision";
    @SerializedName(value="decision")
    private WhatsappReviewDecision decision;
    public static final String SERIALIZED_NAME_UPDATE_EVENT = "updateEvent";
    @SerializedName(value="updateEvent")
    private WhatsappBusinessAccountUpdateEventEnum updateEvent;
    public static final String SERIALIZED_NAME_BAN_STATE = "banState";
    @SerializedName(value="banState")
    private WhatsappBusinessAccountBanState banState;
    public static final String SERIALIZED_NAME_BAN_DATE = "banDate";
    @SerializedName(value="banDate")
    private String banDate;
    public static final String SERIALIZED_NAME_VIOLATION_TYPE = "violationType";
    @SerializedName(value="violationType")
    private String violationType;
    public static final String SERIALIZED_NAME_RESTRICTIONS = "restrictions";
    @SerializedName(value="restrictions")
    private List<WhatsappBusinessAccountRestrictionInfo> restrictions = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public WhatsappBusinessAccount id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of the WhatApp Business Account.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public WhatsappBusinessAccount name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="User-friendly name to differentiate WhatsApp Business Accounts.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WhatsappBusinessAccount currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The currency in which the payment transactions for the WhatsApp Business Account will be processed.")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public WhatsappBusinessAccount messageTemplateNamespace(String messageTemplateNamespace) {
        this.messageTemplateNamespace = messageTemplateNamespace;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Namespace string for the message templates that belong to the WhatsApp Business Account.")
    public String getMessageTemplateNamespace() {
        return this.messageTemplateNamespace;
    }

    public void setMessageTemplateNamespace(String messageTemplateNamespace) {
        this.messageTemplateNamespace = messageTemplateNamespace;
    }

    public WhatsappBusinessAccount accountReviewStatus(WhatsappBusinessAccountReviewStatus accountReviewStatus) {
        this.accountReviewStatus = accountReviewStatus;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappBusinessAccountReviewStatus getAccountReviewStatus() {
        return this.accountReviewStatus;
    }

    public void setAccountReviewStatus(WhatsappBusinessAccountReviewStatus accountReviewStatus) {
        this.accountReviewStatus = accountReviewStatus;
    }

    public WhatsappBusinessAccount businessVerificationStatus(MetaBusinessAccountVerificationStatus businessVerificationStatus) {
        this.businessVerificationStatus = businessVerificationStatus;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public MetaBusinessAccountVerificationStatus getBusinessVerificationStatus() {
        return this.businessVerificationStatus;
    }

    public void setBusinessVerificationStatus(MetaBusinessAccountVerificationStatus businessVerificationStatus) {
        this.businessVerificationStatus = businessVerificationStatus;
    }

    public WhatsappBusinessAccount country(String country) {
        this.country = country;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Country of the WhatsApp Business Account's owning Meta Business account.")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public WhatsappBusinessAccount ownershipType(String ownershipType) {
        this.ownershipType = ownershipType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Ownership type of the WhatsApp Business Account.")
    public String getOwnershipType() {
        return this.ownershipType;
    }

    public void setOwnershipType(String ownershipType) {
        this.ownershipType = ownershipType;
    }

    public WhatsappBusinessAccount primaryFundingId(String primaryFundingId) {
        this.primaryFundingId = primaryFundingId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Primary funding ID for the WhatsApp Business Account paid service.")
    public String getPrimaryFundingId() {
        return this.primaryFundingId;
    }

    public void setPrimaryFundingId(String primaryFundingId) {
        this.primaryFundingId = primaryFundingId;
    }

    public WhatsappBusinessAccount purchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The purchase order number supplied by the business for payment management purposes.")
    public String getPurchaseOrderNumber() {
        return this.purchaseOrderNumber;
    }

    public void setPurchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
    }

    public WhatsappBusinessAccount timezoneId(String timezoneId) {
        this.timezoneId = timezoneId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1", value="The timezone ID of the WhatsApp Business Account. See [Timezone IDs](https://developers.facebook.com/docs/marketing-api/reference/ad-account/timezone-ids).")
    public String getTimezoneId() {
        return this.timezoneId;
    }

    public void setTimezoneId(String timezoneId) {
        this.timezoneId = timezoneId;
    }

    public WhatsappBusinessAccount decision(WhatsappReviewDecision decision) {
        this.decision = decision;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappReviewDecision getDecision() {
        return this.decision;
    }

    public void setDecision(WhatsappReviewDecision decision) {
        this.decision = decision;
    }

    public WhatsappBusinessAccount updateEvent(WhatsappBusinessAccountUpdateEventEnum updateEvent) {
        this.updateEvent = updateEvent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappBusinessAccountUpdateEventEnum getUpdateEvent() {
        return this.updateEvent;
    }

    public void setUpdateEvent(WhatsappBusinessAccountUpdateEventEnum updateEvent) {
        this.updateEvent = updateEvent;
    }

    public WhatsappBusinessAccount banState(WhatsappBusinessAccountBanState banState) {
        this.banState = banState;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappBusinessAccountBanState getBanState() {
        return this.banState;
    }

    public void setBanState(WhatsappBusinessAccountBanState banState) {
        this.banState = banState;
    }

    public WhatsappBusinessAccount banDate(String banDate) {
        this.banDate = banDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="December 9, 2022", value="The date when the WABA is banned.")
    public String getBanDate() {
        return this.banDate;
    }

    public void setBanDate(String banDate) {
        this.banDate = banDate;
    }

    public WhatsappBusinessAccount violationType(String violationType) {
        this.violationType = violationType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="SCAM", value="Used to report violations imposed on the WABA. See also [WhatsApp Business Platform Policy Violations](https://developers.facebook.com/docs/whatsapp/overview/policy-enforcement/violations).")
    public String getViolationType() {
        return this.violationType;
    }

    public void setViolationType(String violationType) {
        this.violationType = violationType;
    }

    public WhatsappBusinessAccount restrictions(List<WhatsappBusinessAccountRestrictionInfo> restrictions) {
        this.restrictions = restrictions;
        return this;
    }

    public WhatsappBusinessAccount addRestrictionsItem(WhatsappBusinessAccountRestrictionInfo restrictionsItem) {
        if (this.restrictions == null) {
            this.restrictions = new ArrayList<WhatsappBusinessAccountRestrictionInfo>();
        }
        this.restrictions.add(restrictionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Used to report restrictions imposed on the WABA, when that WABA violates [WhatsApp Business Platform policies](https://developers.facebook.com/docs/whatsapp/overview/policy-enforcement).")
    public List<WhatsappBusinessAccountRestrictionInfo> getRestrictions() {
        return this.restrictions;
    }

    public void setRestrictions(List<WhatsappBusinessAccountRestrictionInfo> restrictions) {
        this.restrictions = restrictions;
    }

    public WhatsappBusinessAccount putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WhatsappBusinessAccount whatsappBusinessAccount = (WhatsappBusinessAccount)o;
        return Objects.equals(this.id, whatsappBusinessAccount.id) && Objects.equals(this.name, whatsappBusinessAccount.name) && Objects.equals(this.currency, whatsappBusinessAccount.currency) && Objects.equals(this.messageTemplateNamespace, whatsappBusinessAccount.messageTemplateNamespace) && Objects.equals((Object)this.accountReviewStatus, (Object)whatsappBusinessAccount.accountReviewStatus) && Objects.equals((Object)this.businessVerificationStatus, (Object)whatsappBusinessAccount.businessVerificationStatus) && Objects.equals(this.country, whatsappBusinessAccount.country) && Objects.equals(this.ownershipType, whatsappBusinessAccount.ownershipType) && Objects.equals(this.primaryFundingId, whatsappBusinessAccount.primaryFundingId) && Objects.equals(this.purchaseOrderNumber, whatsappBusinessAccount.purchaseOrderNumber) && Objects.equals(this.timezoneId, whatsappBusinessAccount.timezoneId) && Objects.equals((Object)this.decision, (Object)whatsappBusinessAccount.decision) && Objects.equals((Object)this.updateEvent, (Object)whatsappBusinessAccount.updateEvent) && Objects.equals((Object)this.banState, (Object)whatsappBusinessAccount.banState) && Objects.equals(this.banDate, whatsappBusinessAccount.banDate) && Objects.equals(this.violationType, whatsappBusinessAccount.violationType) && Objects.equals(this.restrictions, whatsappBusinessAccount.restrictions) && Objects.equals(this.additionalProperties, whatsappBusinessAccount.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.currency, this.messageTemplateNamespace, this.accountReviewStatus, this.businessVerificationStatus, this.country, this.ownershipType, this.primaryFundingId, this.purchaseOrderNumber, this.timezoneId, this.decision, this.updateEvent, this.banState, this.banDate, this.violationType, this.restrictions, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WhatsappBusinessAccount {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    messageTemplateNamespace: ").append(this.toIndentedString(this.messageTemplateNamespace)).append("\n");
        sb.append("    accountReviewStatus: ").append(this.toIndentedString((Object)this.accountReviewStatus)).append("\n");
        sb.append("    businessVerificationStatus: ").append(this.toIndentedString((Object)this.businessVerificationStatus)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    ownershipType: ").append(this.toIndentedString(this.ownershipType)).append("\n");
        sb.append("    primaryFundingId: ").append(this.toIndentedString(this.primaryFundingId)).append("\n");
        sb.append("    purchaseOrderNumber: ").append(this.toIndentedString(this.purchaseOrderNumber)).append("\n");
        sb.append("    timezoneId: ").append(this.toIndentedString(this.timezoneId)).append("\n");
        sb.append("    decision: ").append(this.toIndentedString((Object)this.decision)).append("\n");
        sb.append("    updateEvent: ").append(this.toIndentedString((Object)this.updateEvent)).append("\n");
        sb.append("    banState: ").append(this.toIndentedString((Object)this.banState)).append("\n");
        sb.append("    banDate: ").append(this.toIndentedString(this.banDate)).append("\n");
        sb.append("    violationType: ").append(this.toIndentedString(this.violationType)).append("\n");
        sb.append("    restrictions: ").append(this.toIndentedString(this.restrictions)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in WhatsappBusinessAccount is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CURRENCY) != null && !jsonObj.get(SERIALIZED_NAME_CURRENCY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `currency` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CURRENCY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MESSAGE_TEMPLATE_NAMESPACE) != null && !jsonObj.get(SERIALIZED_NAME_MESSAGE_TEMPLATE_NAMESPACE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `messageTemplateNamespace` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MESSAGE_TEMPLATE_NAMESPACE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COUNTRY) != null && !jsonObj.get(SERIALIZED_NAME_COUNTRY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `country` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COUNTRY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OWNERSHIP_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_OWNERSHIP_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `ownershipType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OWNERSHIP_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PRIMARY_FUNDING_ID) != null && !jsonObj.get(SERIALIZED_NAME_PRIMARY_FUNDING_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `primaryFundingId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PRIMARY_FUNDING_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PURCHASE_ORDER_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_PURCHASE_ORDER_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `purchaseOrderNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PURCHASE_ORDER_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TIMEZONE_ID) != null && !jsonObj.get(SERIALIZED_NAME_TIMEZONE_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `timezoneId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TIMEZONE_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BAN_DATE) != null && !jsonObj.get(SERIALIZED_NAME_BAN_DATE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `banDate` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BAN_DATE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VIOLATION_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_VIOLATION_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `violationType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VIOLATION_TYPE).toString()));
        }
        JsonArray jsonArrayrestrictions = jsonObj.getAsJsonArray(SERIALIZED_NAME_RESTRICTIONS);
        if (jsonArrayrestrictions != null) {
            if (!jsonObj.get(SERIALIZED_NAME_RESTRICTIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `restrictions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESTRICTIONS).toString()));
            }
            for (int i = 0; i < jsonArrayrestrictions.size(); ++i) {
                WhatsappBusinessAccountRestrictionInfo.validateJsonObject(jsonArrayrestrictions.get(i).getAsJsonObject());
            }
        }
    }

    public static WhatsappBusinessAccount fromJson(String jsonString) throws IOException {
        return (WhatsappBusinessAccount)JSON.getGson().fromJson(jsonString, WhatsappBusinessAccount.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_CURRENCY);
        openapiFields.add(SERIALIZED_NAME_MESSAGE_TEMPLATE_NAMESPACE);
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_REVIEW_STATUS);
        openapiFields.add(SERIALIZED_NAME_BUSINESS_VERIFICATION_STATUS);
        openapiFields.add(SERIALIZED_NAME_COUNTRY);
        openapiFields.add(SERIALIZED_NAME_OWNERSHIP_TYPE);
        openapiFields.add(SERIALIZED_NAME_PRIMARY_FUNDING_ID);
        openapiFields.add(SERIALIZED_NAME_PURCHASE_ORDER_NUMBER);
        openapiFields.add(SERIALIZED_NAME_TIMEZONE_ID);
        openapiFields.add(SERIALIZED_NAME_DECISION);
        openapiFields.add(SERIALIZED_NAME_UPDATE_EVENT);
        openapiFields.add(SERIALIZED_NAME_BAN_STATE);
        openapiFields.add(SERIALIZED_NAME_BAN_DATE);
        openapiFields.add(SERIALIZED_NAME_VIOLATION_TYPE);
        openapiFields.add(SERIALIZED_NAME_RESTRICTIONS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!WhatsappBusinessAccount.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(WhatsappBusinessAccount.class));
            return new TypeAdapter<WhatsappBusinessAccount>(){

                public void write(JsonWriter out, WhatsappBusinessAccount value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public WhatsappBusinessAccount read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    WhatsappBusinessAccount.validateJsonObject(jsonObj);
                    WhatsappBusinessAccount instance = (WhatsappBusinessAccount)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

