/*
 * Decompiled with CFR 0.152.
 */
package com.ycloud.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ycloud.client.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Used to report restrictions imposed on a specific WABA, when that WABA violates [WhatsApp Business Platform policies](https://developers.facebook.com/docs/whatsapp/overview/policy-enforcement).")
public class WhatsappBusinessAccountRestrictionInfo {
    public static final String SERIALIZED_NAME_RESTRICTION_TYPE = "restrictionType";
    @SerializedName(value="restrictionType")
    private RestrictionTypeEnum restrictionType;
    public static final String SERIALIZED_NAME_EXPIRATION = "expiration";
    @SerializedName(value="expiration")
    private Date expiration;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public WhatsappBusinessAccountRestrictionInfo restrictionType(RestrictionTypeEnum restrictionType) {
        this.restrictionType = restrictionType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restriction type.")
    public RestrictionTypeEnum getRestrictionType() {
        return this.restrictionType;
    }

    public void setRestrictionType(RestrictionTypeEnum restrictionType) {
        this.restrictionType = restrictionType;
    }

    public WhatsappBusinessAccountRestrictionInfo expiration(Date expiration) {
        this.expiration = expiration;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2022-06-01T12:00Z", value="The time at which this restriction expires, formatted in [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339). e.g., `2022-06-01T12:00:00.000Z`.")
    public Date getExpiration() {
        return this.expiration;
    }

    public void setExpiration(Date expiration) {
        this.expiration = expiration;
    }

    public WhatsappBusinessAccountRestrictionInfo putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WhatsappBusinessAccountRestrictionInfo whatsappBusinessAccountRestrictionInfo = (WhatsappBusinessAccountRestrictionInfo)o;
        return Objects.equals((Object)this.restrictionType, (Object)whatsappBusinessAccountRestrictionInfo.restrictionType) && Objects.equals(this.expiration, whatsappBusinessAccountRestrictionInfo.expiration) && Objects.equals(this.additionalProperties, whatsappBusinessAccountRestrictionInfo.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.restrictionType, this.expiration, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WhatsappBusinessAccountRestrictionInfo {\n");
        sb.append("    restrictionType: ").append(this.toIndentedString((Object)this.restrictionType)).append("\n");
        sb.append("    expiration: ").append(this.toIndentedString(this.expiration)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in WhatsappBusinessAccountRestrictionInfo is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESTRICTION_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_RESTRICTION_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `restrictionType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESTRICTION_TYPE).toString()));
        }
    }

    public static WhatsappBusinessAccountRestrictionInfo fromJson(String jsonString) throws IOException {
        return (WhatsappBusinessAccountRestrictionInfo)JSON.getGson().fromJson(jsonString, WhatsappBusinessAccountRestrictionInfo.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_RESTRICTION_TYPE);
        openapiFields.add(SERIALIZED_NAME_EXPIRATION);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!WhatsappBusinessAccountRestrictionInfo.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(WhatsappBusinessAccountRestrictionInfo.class));
            return new TypeAdapter<WhatsappBusinessAccountRestrictionInfo>(){

                public void write(JsonWriter out, WhatsappBusinessAccountRestrictionInfo value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public WhatsappBusinessAccountRestrictionInfo read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    WhatsappBusinessAccountRestrictionInfo.validateJsonObject(jsonObj);
                    WhatsappBusinessAccountRestrictionInfo instance = (WhatsappBusinessAccountRestrictionInfo)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RestrictionTypeEnum {
        ADD_PHONE_NUMBER_ACTION("RESTRICTED_ADD_PHONE_NUMBER_ACTION"),
        BIZ_INITIATED_MESSAGING("RESTRICTED_BIZ_INITIATED_MESSAGING"),
        CUSTOMER_INITIATED_MESSAGING("RESTRICTED_CUSTOMER_INITIATED_MESSAGING");

        private String value;

        private RestrictionTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RestrictionTypeEnum fromValue(String value) {
            for (RestrictionTypeEnum b : RestrictionTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<RestrictionTypeEnum> {
            public void write(JsonWriter jsonWriter, RestrictionTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RestrictionTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RestrictionTypeEnum.fromValue(value);
            }
        }
    }
}

