/*
 * Decompiled with CFR 0.152.
 */
package com.ycloud.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ycloud.client.JSON;
import com.ycloud.client.model.WhatsappInboundMessageReferredProduct;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Message context.")
public class WhatsappInboundMessageContext {
    public static final String SERIALIZED_NAME_FORWARDED = "forwarded";
    @SerializedName(value="forwarded")
    private Boolean forwarded;
    public static final String SERIALIZED_NAME_FREQUENTLY_FORWARDED = "frequently_forwarded";
    @SerializedName(value="frequently_forwarded")
    private Boolean frequentlyForwarded;
    public static final String SERIALIZED_NAME_FROM = "from";
    @SerializedName(value="from")
    private String from;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_REFERRED_PRODUCT = "referred_product";
    @SerializedName(value="referred_product")
    private WhatsappInboundMessageReferredProduct referredProduct;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public WhatsappInboundMessageContext forwarded(Boolean forwarded) {
        this.forwarded = forwarded;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="**Added to Webhooks if message was forwarded.**  Set to `true` if the received message has been forwarded.")
    public Boolean getForwarded() {
        return this.forwarded;
    }

    public void setForwarded(Boolean forwarded) {
        this.forwarded = forwarded;
    }

    public WhatsappInboundMessageContext frequentlyForwarded(Boolean frequentlyForwarded) {
        this.frequentlyForwarded = frequentlyForwarded;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="**Added to Webhooks if message has been frequently forwarded.**  Set to `true` if the received message has been forwarded more than five times.")
    public Boolean getFrequentlyForwarded() {
        return this.frequentlyForwarded;
    }

    public void setFrequentlyForwarded(Boolean frequentlyForwarded) {
        this.frequentlyForwarded = frequentlyForwarded;
    }

    public WhatsappInboundMessageContext from(String from) {
        this.from = from;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="**Added to Webhooks if message is an inbound reply to a sent message.**  The WhatsApp ID (a phone number without the '+' prefix) of the sender of the sent message.")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public WhatsappInboundMessageContext id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="wamid.BgNODYxN...", value="**Optional.**  The `wamid` for the sent message for an inbound reply.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public WhatsappInboundMessageContext referredProduct(WhatsappInboundMessageReferredProduct referredProduct) {
        this.referredProduct = referredProduct;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappInboundMessageReferredProduct getReferredProduct() {
        return this.referredProduct;
    }

    public void setReferredProduct(WhatsappInboundMessageReferredProduct referredProduct) {
        this.referredProduct = referredProduct;
    }

    public WhatsappInboundMessageContext putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WhatsappInboundMessageContext whatsappInboundMessageContext = (WhatsappInboundMessageContext)o;
        return Objects.equals(this.forwarded, whatsappInboundMessageContext.forwarded) && Objects.equals(this.frequentlyForwarded, whatsappInboundMessageContext.frequentlyForwarded) && Objects.equals(this.from, whatsappInboundMessageContext.from) && Objects.equals(this.id, whatsappInboundMessageContext.id) && Objects.equals(this.referredProduct, whatsappInboundMessageContext.referredProduct) && Objects.equals(this.additionalProperties, whatsappInboundMessageContext.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.forwarded, this.frequentlyForwarded, this.from, this.id, this.referredProduct, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WhatsappInboundMessageContext {\n");
        sb.append("    forwarded: ").append(this.toIndentedString(this.forwarded)).append("\n");
        sb.append("    frequentlyForwarded: ").append(this.toIndentedString(this.frequentlyForwarded)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    referredProduct: ").append(this.toIndentedString(this.referredProduct)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in WhatsappInboundMessageContext is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FROM) != null && !jsonObj.get(SERIALIZED_NAME_FROM).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `from` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FROM).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_REFERRED_PRODUCT) != null) {
            WhatsappInboundMessageReferredProduct.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_REFERRED_PRODUCT));
        }
    }

    public static WhatsappInboundMessageContext fromJson(String jsonString) throws IOException {
        return (WhatsappInboundMessageContext)JSON.getGson().fromJson(jsonString, WhatsappInboundMessageContext.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_FORWARDED);
        openapiFields.add(SERIALIZED_NAME_FREQUENTLY_FORWARDED);
        openapiFields.add(SERIALIZED_NAME_FROM);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_REFERRED_PRODUCT);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!WhatsappInboundMessageContext.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(WhatsappInboundMessageContext.class));
            return new TypeAdapter<WhatsappInboundMessageContext>(){

                public void write(JsonWriter out, WhatsappInboundMessageContext value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public WhatsappInboundMessageContext read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    WhatsappInboundMessageContext.validateJsonObject(jsonObj);
                    WhatsappInboundMessageContext instance = (WhatsappInboundMessageContext)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

