/*
 * Decompiled with CFR 0.152.
 */
package com.ycloud.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ycloud.client.JSON;
import com.ycloud.client.model.WhatsappInboundMessageInteractiveButtonReply;
import com.ycloud.client.model.WhatsappInboundMessageInteractiveListReply;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="When a customer has interacted with your message, this object is included in the message object. See also [WhatsApp webhook messages object](https://developers.facebook.com/docs/whatsapp/cloud-api/webhooks/components#messages-object), and [payload examples](https://developers.facebook.com/docs/whatsapp/cloud-api/webhooks/payload-examples#webhook-notification-payload-examples).")
public class WhatsappInboundMessageInteractive {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_BUTTON_REPLY = "button_reply";
    @SerializedName(value="button_reply")
    private WhatsappInboundMessageInteractiveButtonReply buttonReply;
    public static final String SERIALIZED_NAME_LIST_REPLY = "list_reply";
    @SerializedName(value="list_reply")
    private WhatsappInboundMessageInteractiveListReply listReply;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public WhatsappInboundMessageInteractive type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of interactive message received. - `button_reply`: Sent when a customer clicks a button. - `list_reply`: Sent when a customer selects an item from a list.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public WhatsappInboundMessageInteractive buttonReply(WhatsappInboundMessageInteractiveButtonReply buttonReply) {
        this.buttonReply = buttonReply;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappInboundMessageInteractiveButtonReply getButtonReply() {
        return this.buttonReply;
    }

    public void setButtonReply(WhatsappInboundMessageInteractiveButtonReply buttonReply) {
        this.buttonReply = buttonReply;
    }

    public WhatsappInboundMessageInteractive listReply(WhatsappInboundMessageInteractiveListReply listReply) {
        this.listReply = listReply;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappInboundMessageInteractiveListReply getListReply() {
        return this.listReply;
    }

    public void setListReply(WhatsappInboundMessageInteractiveListReply listReply) {
        this.listReply = listReply;
    }

    public WhatsappInboundMessageInteractive putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WhatsappInboundMessageInteractive whatsappInboundMessageInteractive = (WhatsappInboundMessageInteractive)o;
        return Objects.equals((Object)this.type, (Object)whatsappInboundMessageInteractive.type) && Objects.equals(this.buttonReply, whatsappInboundMessageInteractive.buttonReply) && Objects.equals(this.listReply, whatsappInboundMessageInteractive.listReply) && Objects.equals(this.additionalProperties, whatsappInboundMessageInteractive.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.buttonReply, this.listReply, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WhatsappInboundMessageInteractive {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    buttonReply: ").append(this.toIndentedString(this.buttonReply)).append("\n");
        sb.append("    listReply: ").append(this.toIndentedString(this.listReply)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in WhatsappInboundMessageInteractive is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_BUTTON_REPLY) != null) {
            WhatsappInboundMessageInteractiveButtonReply.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_BUTTON_REPLY));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_LIST_REPLY) != null) {
            WhatsappInboundMessageInteractiveListReply.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_LIST_REPLY));
        }
    }

    public static WhatsappInboundMessageInteractive fromJson(String jsonString) throws IOException {
        return (WhatsappInboundMessageInteractive)JSON.getGson().fromJson(jsonString, WhatsappInboundMessageInteractive.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_BUTTON_REPLY);
        openapiFields.add(SERIALIZED_NAME_LIST_REPLY);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!WhatsappInboundMessageInteractive.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(WhatsappInboundMessageInteractive.class));
            return new TypeAdapter<WhatsappInboundMessageInteractive>(){

                public void write(JsonWriter out, WhatsappInboundMessageInteractive value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public WhatsappInboundMessageInteractive read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    WhatsappInboundMessageInteractive.validateJsonObject(jsonObj);
                    WhatsappInboundMessageInteractive instance = (WhatsappInboundMessageInteractive)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        BUTTON_REPLY("button_reply"),
        LIST_REPLY("list_reply");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

