/*
 * Decompiled with CFR 0.152.
 */
package com.ycloud.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ycloud.client.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="When a message with media (`image` | `document` | `audio` | `video` | `sticker`) is received, the WhatsApp Business API client will download the media. Once the media is downloaded, a notification is sent to your Webhook. This message contains information that identifies the media object and enables you to find and download the object.")
public class WhatsappInboundMessageMedia {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_LINK = "link";
    @SerializedName(value="link")
    private String link;
    public static final String SERIALIZED_NAME_CAPTION = "caption";
    @SerializedName(value="caption")
    private String caption;
    public static final String SERIALIZED_NAME_FILENAME = "filename";
    @SerializedName(value="filename")
    private String filename;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private Map<String, Object> metadata = null;
    public static final String SERIALIZED_NAME_MIME_TYPE = "mime_type";
    @SerializedName(value="mime_type")
    private String mimeType;
    public static final String SERIALIZED_NAME_SHA256 = "sha256";
    @SerializedName(value="sha256")
    private String sha256;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public WhatsappInboundMessageMedia id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of the media. Can be used to delete the media if stored locally on the client.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public WhatsappInboundMessageMedia link(String link) {
        this.link = link;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The url to download the media file. Note that This link can be directly accessed in a few minutes for the convenience of the consumer, but you should always include an `X-API-Key` header to download this file within a month.")
    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public WhatsappInboundMessageMedia caption(String caption) {
        this.caption = caption;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The provided caption for the media. Only present if specified.")
    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public WhatsappInboundMessageMedia filename(String filename) {
        this.filename = filename;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filename on the sender's device. This will only be present in `document` media messages.")
    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public WhatsappInboundMessageMedia metadata(Map<String, Object> metadata) {
        this.metadata = metadata;
        return this;
    }

    public WhatsappInboundMessageMedia putMetadataItem(String key, Object metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, Object>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Metadata pertaining to `sticker` media.")
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public WhatsappInboundMessageMedia mimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Mime type of the media.")
    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public WhatsappInboundMessageMedia sha256(String sha256) {
        this.sha256 = sha256;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Checksum.")
    public String getSha256() {
        return this.sha256;
    }

    public void setSha256(String sha256) {
        this.sha256 = sha256;
    }

    public WhatsappInboundMessageMedia putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WhatsappInboundMessageMedia whatsappInboundMessageMedia = (WhatsappInboundMessageMedia)o;
        return Objects.equals(this.id, whatsappInboundMessageMedia.id) && Objects.equals(this.link, whatsappInboundMessageMedia.link) && Objects.equals(this.caption, whatsappInboundMessageMedia.caption) && Objects.equals(this.filename, whatsappInboundMessageMedia.filename) && Objects.equals(this.metadata, whatsappInboundMessageMedia.metadata) && Objects.equals(this.mimeType, whatsappInboundMessageMedia.mimeType) && Objects.equals(this.sha256, whatsappInboundMessageMedia.sha256) && Objects.equals(this.additionalProperties, whatsappInboundMessageMedia.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.link, this.caption, this.filename, this.metadata, this.mimeType, this.sha256, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WhatsappInboundMessageMedia {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    link: ").append(this.toIndentedString(this.link)).append("\n");
        sb.append("    caption: ").append(this.toIndentedString(this.caption)).append("\n");
        sb.append("    filename: ").append(this.toIndentedString(this.filename)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    mimeType: ").append(this.toIndentedString(this.mimeType)).append("\n");
        sb.append("    sha256: ").append(this.toIndentedString(this.sha256)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in WhatsappInboundMessageMedia is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LINK) != null && !jsonObj.get(SERIALIZED_NAME_LINK).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `link` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LINK).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CAPTION) != null && !jsonObj.get(SERIALIZED_NAME_CAPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `caption` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CAPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FILENAME) != null && !jsonObj.get(SERIALIZED_NAME_FILENAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `filename` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FILENAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MIME_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_MIME_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `mime_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MIME_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHA256) != null && !jsonObj.get(SERIALIZED_NAME_SHA256).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `sha256` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHA256).toString()));
        }
    }

    public static WhatsappInboundMessageMedia fromJson(String jsonString) throws IOException {
        return (WhatsappInboundMessageMedia)JSON.getGson().fromJson(jsonString, WhatsappInboundMessageMedia.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_LINK);
        openapiFields.add(SERIALIZED_NAME_CAPTION);
        openapiFields.add(SERIALIZED_NAME_FILENAME);
        openapiFields.add(SERIALIZED_NAME_METADATA);
        openapiFields.add(SERIALIZED_NAME_MIME_TYPE);
        openapiFields.add(SERIALIZED_NAME_SHA256);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!WhatsappInboundMessageMedia.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(WhatsappInboundMessageMedia.class));
            return new TypeAdapter<WhatsappInboundMessageMedia>(){

                public void write(JsonWriter out, WhatsappInboundMessageMedia value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public WhatsappInboundMessageMedia read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    WhatsappInboundMessageMedia.validateJsonObject(jsonObj);
                    WhatsappInboundMessageMedia instance = (WhatsappInboundMessageMedia)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

