/*
 * Decompiled with CFR 0.152.
 */
package com.ycloud.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ycloud.client.JSON;
import com.ycloud.client.model.WhatsappInboundMessageOrderProductItem;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="When a customer places an order, the message type is set to `order`, and this field is included.")
public class WhatsappInboundMessageOrder {
    public static final String SERIALIZED_NAME_CATALOG_ID = "catalog_id";
    @SerializedName(value="catalog_id")
    private String catalogId;
    public static final String SERIALIZED_NAME_PRODUCT_ITEMS = "product_items";
    @SerializedName(value="product_items")
    private List<WhatsappInboundMessageOrderProductItem> productItems = null;
    public static final String SERIALIZED_NAME_TEXT = "text";
    @SerializedName(value="text")
    private String text;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public WhatsappInboundMessageOrder catalogId(String catalogId) {
        this.catalogId = catalogId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="the-catalog_id", value="The catalog ID.")
    public String getCatalogId() {
        return this.catalogId;
    }

    public void setCatalogId(String catalogId) {
        this.catalogId = catalogId;
    }

    public WhatsappInboundMessageOrder productItems(List<WhatsappInboundMessageOrderProductItem> productItems) {
        this.productItems = productItems;
        return this;
    }

    public WhatsappInboundMessageOrder addProductItemsItem(WhatsappInboundMessageOrderProductItem productItemsItem) {
        if (this.productItems == null) {
            this.productItems = new ArrayList<WhatsappInboundMessageOrderProductItem>();
        }
        this.productItems.add(productItemsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<WhatsappInboundMessageOrderProductItem> getProductItems() {
        return this.productItems;
    }

    public void setProductItems(List<WhatsappInboundMessageOrderProductItem> productItems) {
        this.productItems = productItems;
    }

    public WhatsappInboundMessageOrder text(String text) {
        this.text = text;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Text message sent along with the order.")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public WhatsappInboundMessageOrder putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WhatsappInboundMessageOrder whatsappInboundMessageOrder = (WhatsappInboundMessageOrder)o;
        return Objects.equals(this.catalogId, whatsappInboundMessageOrder.catalogId) && Objects.equals(this.productItems, whatsappInboundMessageOrder.productItems) && Objects.equals(this.text, whatsappInboundMessageOrder.text) && Objects.equals(this.additionalProperties, whatsappInboundMessageOrder.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.catalogId, this.productItems, this.text, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WhatsappInboundMessageOrder {\n");
        sb.append("    catalogId: ").append(this.toIndentedString(this.catalogId)).append("\n");
        sb.append("    productItems: ").append(this.toIndentedString(this.productItems)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in WhatsappInboundMessageOrder is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CATALOG_ID) != null && !jsonObj.get(SERIALIZED_NAME_CATALOG_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `catalog_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CATALOG_ID).toString()));
        }
        JsonArray jsonArrayproductItems = jsonObj.getAsJsonArray(SERIALIZED_NAME_PRODUCT_ITEMS);
        if (jsonArrayproductItems != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PRODUCT_ITEMS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `product_items` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PRODUCT_ITEMS).toString()));
            }
            for (int i = 0; i < jsonArrayproductItems.size(); ++i) {
                WhatsappInboundMessageOrderProductItem.validateJsonObject(jsonArrayproductItems.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_TEXT) != null && !jsonObj.get(SERIALIZED_NAME_TEXT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `text` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TEXT).toString()));
        }
    }

    public static WhatsappInboundMessageOrder fromJson(String jsonString) throws IOException {
        return (WhatsappInboundMessageOrder)JSON.getGson().fromJson(jsonString, WhatsappInboundMessageOrder.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CATALOG_ID);
        openapiFields.add(SERIALIZED_NAME_PRODUCT_ITEMS);
        openapiFields.add(SERIALIZED_NAME_TEXT);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!WhatsappInboundMessageOrder.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(WhatsappInboundMessageOrder.class));
            return new TypeAdapter<WhatsappInboundMessageOrder>(){

                public void write(JsonWriter out, WhatsappInboundMessageOrder value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public WhatsappInboundMessageOrder read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    WhatsappInboundMessageOrder.validateJsonObject(jsonObj);
                    WhatsappInboundMessageOrder instance = (WhatsappInboundMessageOrder)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

