/*
 * Decompiled with CFR 0.152.
 */
package com.ycloud.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ycloud.client.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="When a user messages businesses using call-to-actions buttons on [Ads that Click to WhatsApp](https://www.facebook.com/business/help/447934475640650) or a [Facebook Page call-to-action buttons](https://www.facebook.com/help/977869848936797), this field is included as an attachment.")
public class WhatsappInboundMessageReferral {
    public static final String SERIALIZED_NAME_SOURCE_URL = "source_url";
    @SerializedName(value="source_url")
    private String sourceUrl;
    public static final String SERIALIZED_NAME_SOURCE_TYPE = "source_type";
    @SerializedName(value="source_type")
    private String sourceType;
    public static final String SERIALIZED_NAME_SOURCE_ID = "source_id";
    @SerializedName(value="source_id")
    private String sourceId;
    public static final String SERIALIZED_NAME_HEADLINE = "headline";
    @SerializedName(value="headline")
    private String headline;
    public static final String SERIALIZED_NAME_BODY = "body";
    @SerializedName(value="body")
    private String body;
    public static final String SERIALIZED_NAME_MEDIA_TYPE = "media_type";
    @SerializedName(value="media_type")
    private String mediaType;
    public static final String SERIALIZED_NAME_IMAGE_URL = "image_url";
    @SerializedName(value="image_url")
    private String imageUrl;
    public static final String SERIALIZED_NAME_VIDEO_URL = "video_url";
    @SerializedName(value="video_url")
    private String videoUrl;
    public static final String SERIALIZED_NAME_THUMBNAIL_URL = "thumbnail_url";
    @SerializedName(value="thumbnail_url")
    private String thumbnailUrl;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public WhatsappInboundMessageReferral sourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the URL that leads to the ad or post clicked by the user. Opening this URL takes you to the ad viewed by your user.")
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public WhatsappInboundMessageReferral sourceType(String sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the type of the ad's source. Supported values are \"ad\" or \"post\".")
    public String getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public WhatsappInboundMessageReferral sourceId(String sourceId) {
        this.sourceId = sourceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the Meta ID for an ad or post.")
    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public WhatsappInboundMessageReferral headline(String headline) {
        this.headline = headline;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the headline used in the ad or post that generated the message.")
    public String getHeadline() {
        return this.headline;
    }

    public void setHeadline(String headline) {
        this.headline = headline;
    }

    public WhatsappInboundMessageReferral body(String body) {
        this.body = body;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The description, or body, from the ad or post that generated the message.")
    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public WhatsappInboundMessageReferral mediaType(String mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Media present in the ad or post the user clicked. Supported values are \"image\" or \"video\".")
    public String getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public WhatsappInboundMessageReferral imageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="**Added if media_type is \"image\".**  Contains a URL to the raw image.")
    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public WhatsappInboundMessageReferral videoUrl(String videoUrl) {
        this.videoUrl = videoUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="**Added if media_type is \"video\".**  Contains a URL to the video.")
    public String getVideoUrl() {
        return this.videoUrl;
    }

    public void setVideoUrl(String videoUrl) {
        this.videoUrl = videoUrl;
    }

    public WhatsappInboundMessageReferral thumbnailUrl(String thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="**Added if media_type is \"video\".**  Contains a URL to the thumbnail image of the clicked video.")
    public String getThumbnailUrl() {
        return this.thumbnailUrl;
    }

    public void setThumbnailUrl(String thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
    }

    public WhatsappInboundMessageReferral putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WhatsappInboundMessageReferral whatsappInboundMessageReferral = (WhatsappInboundMessageReferral)o;
        return Objects.equals(this.sourceUrl, whatsappInboundMessageReferral.sourceUrl) && Objects.equals(this.sourceType, whatsappInboundMessageReferral.sourceType) && Objects.equals(this.sourceId, whatsappInboundMessageReferral.sourceId) && Objects.equals(this.headline, whatsappInboundMessageReferral.headline) && Objects.equals(this.body, whatsappInboundMessageReferral.body) && Objects.equals(this.mediaType, whatsappInboundMessageReferral.mediaType) && Objects.equals(this.imageUrl, whatsappInboundMessageReferral.imageUrl) && Objects.equals(this.videoUrl, whatsappInboundMessageReferral.videoUrl) && Objects.equals(this.thumbnailUrl, whatsappInboundMessageReferral.thumbnailUrl) && Objects.equals(this.additionalProperties, whatsappInboundMessageReferral.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.sourceUrl, this.sourceType, this.sourceId, this.headline, this.body, this.mediaType, this.imageUrl, this.videoUrl, this.thumbnailUrl, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WhatsappInboundMessageReferral {\n");
        sb.append("    sourceUrl: ").append(this.toIndentedString(this.sourceUrl)).append("\n");
        sb.append("    sourceType: ").append(this.toIndentedString(this.sourceType)).append("\n");
        sb.append("    sourceId: ").append(this.toIndentedString(this.sourceId)).append("\n");
        sb.append("    headline: ").append(this.toIndentedString(this.headline)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString(this.mediaType)).append("\n");
        sb.append("    imageUrl: ").append(this.toIndentedString(this.imageUrl)).append("\n");
        sb.append("    videoUrl: ").append(this.toIndentedString(this.videoUrl)).append("\n");
        sb.append("    thumbnailUrl: ").append(this.toIndentedString(this.thumbnailUrl)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in WhatsappInboundMessageReferral is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SOURCE_URL) != null && !jsonObj.get(SERIALIZED_NAME_SOURCE_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `source_url` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SOURCE_URL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SOURCE_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_SOURCE_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `source_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SOURCE_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SOURCE_ID) != null && !jsonObj.get(SERIALIZED_NAME_SOURCE_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `source_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SOURCE_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HEADLINE) != null && !jsonObj.get(SERIALIZED_NAME_HEADLINE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `headline` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HEADLINE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BODY) != null && !jsonObj.get(SERIALIZED_NAME_BODY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `body` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BODY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MEDIA_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_MEDIA_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `media_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MEDIA_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IMAGE_URL) != null && !jsonObj.get(SERIALIZED_NAME_IMAGE_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `image_url` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IMAGE_URL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VIDEO_URL) != null && !jsonObj.get(SERIALIZED_NAME_VIDEO_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `video_url` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VIDEO_URL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_THUMBNAIL_URL) != null && !jsonObj.get(SERIALIZED_NAME_THUMBNAIL_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `thumbnail_url` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_THUMBNAIL_URL).toString()));
        }
    }

    public static WhatsappInboundMessageReferral fromJson(String jsonString) throws IOException {
        return (WhatsappInboundMessageReferral)JSON.getGson().fromJson(jsonString, WhatsappInboundMessageReferral.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_SOURCE_URL);
        openapiFields.add(SERIALIZED_NAME_SOURCE_TYPE);
        openapiFields.add(SERIALIZED_NAME_SOURCE_ID);
        openapiFields.add(SERIALIZED_NAME_HEADLINE);
        openapiFields.add(SERIALIZED_NAME_BODY);
        openapiFields.add(SERIALIZED_NAME_MEDIA_TYPE);
        openapiFields.add(SERIALIZED_NAME_IMAGE_URL);
        openapiFields.add(SERIALIZED_NAME_VIDEO_URL);
        openapiFields.add(SERIALIZED_NAME_THUMBNAIL_URL);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!WhatsappInboundMessageReferral.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(WhatsappInboundMessageReferral.class));
            return new TypeAdapter<WhatsappInboundMessageReferral>(){

                public void write(JsonWriter out, WhatsappInboundMessageReferral value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public WhatsappInboundMessageReferral read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    WhatsappInboundMessageReferral.validateJsonObject(jsonObj);
                    WhatsappInboundMessageReferral instance = (WhatsappInboundMessageReferral)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

