/*
 * Decompiled with CFR 0.152.
 */
package com.ycloud.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ycloud.client.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="When the message type is set to `system`, this field is included. This object is added to Webhooks if a user has changed their phone number and if a user\u2019s identity has potentially changed on WhatsApp.")
public class WhatsappInboundMessageSystem {
    public static final String SERIALIZED_NAME_BODY = "body";
    @SerializedName(value="body")
    private String body;
    public static final String SERIALIZED_NAME_NEW_WA_ID = "new_wa_id";
    @SerializedName(value="new_wa_id")
    private String newWaId;
    public static final String SERIALIZED_NAME_IDENTITY = "identity";
    @SerializedName(value="identity")
    private String identity;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(value="user")
    private String user;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public WhatsappInboundMessageSystem body(String body) {
        this.body = body;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Describes the system message event. Supported use cases are: - Phone number update: for when a user changes from an old number to a new number. - Identity update: for when a user identity has changed.")
    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public WhatsappInboundMessageSystem newWaId(String newWaId) {
        this.newWaId = newWaId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="**Added to Webhooks for phone number updates.**  New WhatsApp ID of the customer.")
    public String getNewWaId() {
        return this.newWaId;
    }

    public void setNewWaId(String newWaId) {
        this.newWaId = newWaId;
    }

    public WhatsappInboundMessageSystem identity(String identity) {
        this.identity = identity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="**Added to Webhooks for identity updates.**  New WhatsApp ID of the customer.")
    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public WhatsappInboundMessageSystem type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Supported types are: - `user_changed_number`: for a user changed number notification. - `user_identity_changed`: for user identity changed notification.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public WhatsappInboundMessageSystem user(String user) {
        this.user = user;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="**Added to Webhooks for identity updates.**  The new WhatsApp user ID of the customer.")
    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public WhatsappInboundMessageSystem putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WhatsappInboundMessageSystem whatsappInboundMessageSystem = (WhatsappInboundMessageSystem)o;
        return Objects.equals(this.body, whatsappInboundMessageSystem.body) && Objects.equals(this.newWaId, whatsappInboundMessageSystem.newWaId) && Objects.equals(this.identity, whatsappInboundMessageSystem.identity) && Objects.equals(this.type, whatsappInboundMessageSystem.type) && Objects.equals(this.user, whatsappInboundMessageSystem.user) && Objects.equals(this.additionalProperties, whatsappInboundMessageSystem.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.body, this.newWaId, this.identity, this.type, this.user, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WhatsappInboundMessageSystem {\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    newWaId: ").append(this.toIndentedString(this.newWaId)).append("\n");
        sb.append("    identity: ").append(this.toIndentedString(this.identity)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in WhatsappInboundMessageSystem is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BODY) != null && !jsonObj.get(SERIALIZED_NAME_BODY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `body` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BODY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NEW_WA_ID) != null && !jsonObj.get(SERIALIZED_NAME_NEW_WA_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `new_wa_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NEW_WA_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IDENTITY) != null && !jsonObj.get(SERIALIZED_NAME_IDENTITY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `identity` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IDENTITY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_USER) != null && !jsonObj.get(SERIALIZED_NAME_USER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `user` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USER).toString()));
        }
    }

    public static WhatsappInboundMessageSystem fromJson(String jsonString) throws IOException {
        return (WhatsappInboundMessageSystem)JSON.getGson().fromJson(jsonString, WhatsappInboundMessageSystem.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BODY);
        openapiFields.add(SERIALIZED_NAME_NEW_WA_ID);
        openapiFields.add(SERIALIZED_NAME_IDENTITY);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_USER);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!WhatsappInboundMessageSystem.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(WhatsappInboundMessageSystem.class));
            return new TypeAdapter<WhatsappInboundMessageSystem>(){

                public void write(JsonWriter out, WhatsappInboundMessageSystem value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public WhatsappInboundMessageSystem read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    WhatsappInboundMessageSystem.validateJsonObject(jsonObj);
                    WhatsappInboundMessageSystem instance = (WhatsappInboundMessageSystem)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

