/*
 * Decompiled with CFR 0.152.
 */
package com.ycloud.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ycloud.client.JSON;
import com.ycloud.client.model.WhatsappMessageContactAddressesInner;
import com.ycloud.client.model.WhatsappMessageContactEmailsInner;
import com.ycloud.client.model.WhatsappMessageContactName;
import com.ycloud.client.model.WhatsappMessageContactOrg;
import com.ycloud.client.model.WhatsappMessageContactPhonesInner;
import com.ycloud.client.model.WhatsappMessageContactUrlsInner;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="When the message type filed is set to `contacts`, this object is included in the message object. See also [WhatsApp message contacts object](https://developers.facebook.com/docs/whatsapp/cloud-api/reference/messages#contacts-object).")
public class WhatsappMessageContact {
    public static final String SERIALIZED_NAME_ADDRESSES = "addresses";
    @SerializedName(value="addresses")
    private List<WhatsappMessageContactAddressesInner> addresses = null;
    public static final String SERIALIZED_NAME_BIRTHDAY = "birthday";
    @SerializedName(value="birthday")
    private String birthday;
    public static final String SERIALIZED_NAME_EMAILS = "emails";
    @SerializedName(value="emails")
    private List<WhatsappMessageContactEmailsInner> emails = null;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private WhatsappMessageContactName name;
    public static final String SERIALIZED_NAME_ORG = "org";
    @SerializedName(value="org")
    private WhatsappMessageContactOrg org;
    public static final String SERIALIZED_NAME_PHONES = "phones";
    @SerializedName(value="phones")
    private List<WhatsappMessageContactPhonesInner> phones = null;
    public static final String SERIALIZED_NAME_URLS = "urls";
    @SerializedName(value="urls")
    private List<WhatsappMessageContactUrlsInner> urls = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public WhatsappMessageContact addresses(List<WhatsappMessageContactAddressesInner> addresses) {
        this.addresses = addresses;
        return this;
    }

    public WhatsappMessageContact addAddressesItem(WhatsappMessageContactAddressesInner addressesItem) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<WhatsappMessageContactAddressesInner>();
        }
        this.addresses.add(addressesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<WhatsappMessageContactAddressesInner> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<WhatsappMessageContactAddressesInner> addresses) {
        this.addresses = addresses;
    }

    public WhatsappMessageContact birthday(String birthday) {
        this.birthday = birthday;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2022-09-27", value="`YYYY-MM-DD` formatted string.")
    public String getBirthday() {
        return this.birthday;
    }

    public void setBirthday(String birthday) {
        this.birthday = birthday;
    }

    public WhatsappMessageContact emails(List<WhatsappMessageContactEmailsInner> emails) {
        this.emails = emails;
        return this;
    }

    public WhatsappMessageContact addEmailsItem(WhatsappMessageContactEmailsInner emailsItem) {
        if (this.emails == null) {
            this.emails = new ArrayList<WhatsappMessageContactEmailsInner>();
        }
        this.emails.add(emailsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<WhatsappMessageContactEmailsInner> getEmails() {
        return this.emails;
    }

    public void setEmails(List<WhatsappMessageContactEmailsInner> emails) {
        this.emails = emails;
    }

    public WhatsappMessageContact name(WhatsappMessageContactName name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappMessageContactName getName() {
        return this.name;
    }

    public void setName(WhatsappMessageContactName name) {
        this.name = name;
    }

    public WhatsappMessageContact org(WhatsappMessageContactOrg org) {
        this.org = org;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappMessageContactOrg getOrg() {
        return this.org;
    }

    public void setOrg(WhatsappMessageContactOrg org) {
        this.org = org;
    }

    public WhatsappMessageContact phones(List<WhatsappMessageContactPhonesInner> phones) {
        this.phones = phones;
        return this;
    }

    public WhatsappMessageContact addPhonesItem(WhatsappMessageContactPhonesInner phonesItem) {
        if (this.phones == null) {
            this.phones = new ArrayList<WhatsappMessageContactPhonesInner>();
        }
        this.phones.add(phonesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contact phone number(s) formatted as a phone object.")
    public List<WhatsappMessageContactPhonesInner> getPhones() {
        return this.phones;
    }

    public void setPhones(List<WhatsappMessageContactPhonesInner> phones) {
        this.phones = phones;
    }

    public WhatsappMessageContact urls(List<WhatsappMessageContactUrlsInner> urls) {
        this.urls = urls;
        return this;
    }

    public WhatsappMessageContact addUrlsItem(WhatsappMessageContactUrlsInner urlsItem) {
        if (this.urls == null) {
            this.urls = new ArrayList<WhatsappMessageContactUrlsInner>();
        }
        this.urls.add(urlsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contact URL(s) formatted as a urls object.")
    public List<WhatsappMessageContactUrlsInner> getUrls() {
        return this.urls;
    }

    public void setUrls(List<WhatsappMessageContactUrlsInner> urls) {
        this.urls = urls;
    }

    public WhatsappMessageContact putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WhatsappMessageContact whatsappMessageContact = (WhatsappMessageContact)o;
        return Objects.equals(this.addresses, whatsappMessageContact.addresses) && Objects.equals(this.birthday, whatsappMessageContact.birthday) && Objects.equals(this.emails, whatsappMessageContact.emails) && Objects.equals(this.name, whatsappMessageContact.name) && Objects.equals(this.org, whatsappMessageContact.org) && Objects.equals(this.phones, whatsappMessageContact.phones) && Objects.equals(this.urls, whatsappMessageContact.urls) && Objects.equals(this.additionalProperties, whatsappMessageContact.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.addresses, this.birthday, this.emails, this.name, this.org, this.phones, this.urls, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WhatsappMessageContact {\n");
        sb.append("    addresses: ").append(this.toIndentedString(this.addresses)).append("\n");
        sb.append("    birthday: ").append(this.toIndentedString(this.birthday)).append("\n");
        sb.append("    emails: ").append(this.toIndentedString(this.emails)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    org: ").append(this.toIndentedString(this.org)).append("\n");
        sb.append("    phones: ").append(this.toIndentedString(this.phones)).append("\n");
        sb.append("    urls: ").append(this.toIndentedString(this.urls)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayurls;
        JsonArray jsonArrayphones;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in WhatsappMessageContact is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        JsonArray jsonArrayaddresses = jsonObj.getAsJsonArray(SERIALIZED_NAME_ADDRESSES);
        if (jsonArrayaddresses != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ADDRESSES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `addresses` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ADDRESSES).toString()));
            }
            for (int i = 0; i < jsonArrayaddresses.size(); ++i) {
                WhatsappMessageContactAddressesInner.validateJsonObject(jsonArrayaddresses.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_BIRTHDAY) != null && !jsonObj.get(SERIALIZED_NAME_BIRTHDAY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `birthday` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BIRTHDAY).toString()));
        }
        JsonArray jsonArrayemails = jsonObj.getAsJsonArray(SERIALIZED_NAME_EMAILS);
        if (jsonArrayemails != null) {
            if (!jsonObj.get(SERIALIZED_NAME_EMAILS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `emails` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EMAILS).toString()));
            }
            for (int i = 0; i < jsonArrayemails.size(); ++i) {
                WhatsappMessageContactEmailsInner.validateJsonObject(jsonArrayemails.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_NAME) != null) {
            WhatsappMessageContactName.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_NAME));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ORG) != null) {
            WhatsappMessageContactOrg.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ORG));
        }
        if ((jsonArrayphones = jsonObj.getAsJsonArray(SERIALIZED_NAME_PHONES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PHONES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `phones` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PHONES).toString()));
            }
            for (int i = 0; i < jsonArrayphones.size(); ++i) {
                WhatsappMessageContactPhonesInner.validateJsonObject(jsonArrayphones.get(i).getAsJsonObject());
            }
        }
        if ((jsonArrayurls = jsonObj.getAsJsonArray(SERIALIZED_NAME_URLS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_URLS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `urls` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_URLS).toString()));
            }
            for (int i = 0; i < jsonArrayurls.size(); ++i) {
                WhatsappMessageContactUrlsInner.validateJsonObject(jsonArrayurls.get(i).getAsJsonObject());
            }
        }
    }

    public static WhatsappMessageContact fromJson(String jsonString) throws IOException {
        return (WhatsappMessageContact)JSON.getGson().fromJson(jsonString, WhatsappMessageContact.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ADDRESSES);
        openapiFields.add(SERIALIZED_NAME_BIRTHDAY);
        openapiFields.add(SERIALIZED_NAME_EMAILS);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_ORG);
        openapiFields.add(SERIALIZED_NAME_PHONES);
        openapiFields.add(SERIALIZED_NAME_URLS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!WhatsappMessageContact.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(WhatsappMessageContact.class));
            return new TypeAdapter<WhatsappMessageContact>(){

                public void write(JsonWriter out, WhatsappMessageContact value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public WhatsappMessageContact read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    WhatsappMessageContact.validateJsonObject(jsonObj);
                    WhatsappMessageContact instance = (WhatsappMessageContact)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

