/*
 * Decompiled with CFR 0.152.
 */
package com.ycloud.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ycloud.client.JSON;
import com.ycloud.client.model.WhatsappMessageInteractiveAction;
import com.ycloud.client.model.WhatsappMessageInteractiveBody;
import com.ycloud.client.model.WhatsappMessageInteractiveFooter;
import com.ycloud.client.model.WhatsappMessageInteractiveHeader;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="[WhatsApp Interactive Object](https://developers.facebook.com/docs/whatsapp/cloud-api/reference/messages#interactive-object).")
public class WhatsappMessageInteractive {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_ACTION = "action";
    @SerializedName(value="action")
    private WhatsappMessageInteractiveAction action;
    public static final String SERIALIZED_NAME_BODY = "body";
    @SerializedName(value="body")
    private WhatsappMessageInteractiveBody body;
    public static final String SERIALIZED_NAME_HEADER = "header";
    @SerializedName(value="header")
    private WhatsappMessageInteractiveHeader header;
    public static final String SERIALIZED_NAME_FOOTER = "footer";
    @SerializedName(value="footer")
    private WhatsappMessageInteractiveFooter footer;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public WhatsappMessageInteractive type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The type of interactive message you want to send. - `list`: Use it for List Messages. - `button`: Use it for Reply Buttons.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public WhatsappMessageInteractive action(WhatsappMessageInteractiveAction action) {
        this.action = action;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public WhatsappMessageInteractiveAction getAction() {
        return this.action;
    }

    public void setAction(WhatsappMessageInteractiveAction action) {
        this.action = action;
    }

    public WhatsappMessageInteractive body(WhatsappMessageInteractiveBody body) {
        this.body = body;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public WhatsappMessageInteractiveBody getBody() {
        return this.body;
    }

    public void setBody(WhatsappMessageInteractiveBody body) {
        this.body = body;
    }

    public WhatsappMessageInteractive header(WhatsappMessageInteractiveHeader header) {
        this.header = header;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappMessageInteractiveHeader getHeader() {
        return this.header;
    }

    public void setHeader(WhatsappMessageInteractiveHeader header) {
        this.header = header;
    }

    public WhatsappMessageInteractive footer(WhatsappMessageInteractiveFooter footer) {
        this.footer = footer;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappMessageInteractiveFooter getFooter() {
        return this.footer;
    }

    public void setFooter(WhatsappMessageInteractiveFooter footer) {
        this.footer = footer;
    }

    public WhatsappMessageInteractive putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WhatsappMessageInteractive whatsappMessageInteractive = (WhatsappMessageInteractive)o;
        return Objects.equals((Object)this.type, (Object)whatsappMessageInteractive.type) && Objects.equals(this.action, whatsappMessageInteractive.action) && Objects.equals(this.body, whatsappMessageInteractive.body) && Objects.equals(this.header, whatsappMessageInteractive.header) && Objects.equals(this.footer, whatsappMessageInteractive.footer) && Objects.equals(this.additionalProperties, whatsappMessageInteractive.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.action, this.body, this.header, this.footer, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WhatsappMessageInteractive {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    action: ").append(this.toIndentedString(this.action)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    header: ").append(this.toIndentedString(this.header)).append("\n");
        sb.append("    footer: ").append(this.toIndentedString(this.footer)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in WhatsappMessageInteractive is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ACTION) != null) {
            WhatsappMessageInteractiveAction.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ACTION));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_BODY) != null) {
            WhatsappMessageInteractiveBody.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_BODY));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_HEADER) != null) {
            WhatsappMessageInteractiveHeader.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_HEADER));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_FOOTER) != null) {
            WhatsappMessageInteractiveFooter.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_FOOTER));
        }
    }

    public static WhatsappMessageInteractive fromJson(String jsonString) throws IOException {
        return (WhatsappMessageInteractive)JSON.getGson().fromJson(jsonString, WhatsappMessageInteractive.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_ACTION);
        openapiFields.add(SERIALIZED_NAME_BODY);
        openapiFields.add(SERIALIZED_NAME_HEADER);
        openapiFields.add(SERIALIZED_NAME_FOOTER);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_ACTION);
        openapiRequiredFields.add(SERIALIZED_NAME_BODY);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!WhatsappMessageInteractive.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(WhatsappMessageInteractive.class));
            return new TypeAdapter<WhatsappMessageInteractive>(){

                public void write(JsonWriter out, WhatsappMessageInteractive value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public WhatsappMessageInteractive read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    WhatsappMessageInteractive.validateJsonObject(jsonObj);
                    WhatsappMessageInteractive instance = (WhatsappMessageInteractive)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        BUTTON("button"),
        LIST("list");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

