/*
 * Decompiled with CFR 0.152.
 */
package com.ycloud.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ycloud.client.JSON;
import com.ycloud.client.model.WhatsappMessageTemplateComponentsInner;
import com.ycloud.client.model.WhatsappMessageTemplateLanguage;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Template object when sending a WhatsApp template message. See also [WhatsApp Template Object](https://developers.facebook.com/docs/whatsapp/cloud-api/reference/messages#template-object).")
public class WhatsappMessageTemplate {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_LANGUAGE = "language";
    @SerializedName(value="language")
    private WhatsappMessageTemplateLanguage language;
    public static final String SERIALIZED_NAME_COMPONENTS = "components";
    @SerializedName(value="components")
    private List<WhatsappMessageTemplateComponentsInner> components = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public WhatsappMessageTemplate name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="sample_whatsapp_template", required=true, value="Name of the template.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WhatsappMessageTemplate language(WhatsappMessageTemplateLanguage language) {
        this.language = language;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public WhatsappMessageTemplateLanguage getLanguage() {
        return this.language;
    }

    public void setLanguage(WhatsappMessageTemplateLanguage language) {
        this.language = language;
    }

    public WhatsappMessageTemplate components(List<WhatsappMessageTemplateComponentsInner> components) {
        this.components = components;
        return this;
    }

    public WhatsappMessageTemplate addComponentsItem(WhatsappMessageTemplateComponentsInner componentsItem) {
        if (this.components == null) {
            this.components = new ArrayList<WhatsappMessageTemplateComponentsInner>();
        }
        this.components.add(componentsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of components objects containing the parameters of the message.")
    public List<WhatsappMessageTemplateComponentsInner> getComponents() {
        return this.components;
    }

    public void setComponents(List<WhatsappMessageTemplateComponentsInner> components) {
        this.components = components;
    }

    public WhatsappMessageTemplate putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WhatsappMessageTemplate whatsappMessageTemplate = (WhatsappMessageTemplate)o;
        return Objects.equals(this.name, whatsappMessageTemplate.name) && Objects.equals(this.language, whatsappMessageTemplate.language) && Objects.equals(this.components, whatsappMessageTemplate.components) && Objects.equals(this.additionalProperties, whatsappMessageTemplate.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.language, this.components, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WhatsappMessageTemplate {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    components: ").append(this.toIndentedString(this.components)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraycomponents;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in WhatsappMessageTemplate is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_LANGUAGE) != null) {
            WhatsappMessageTemplateLanguage.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_LANGUAGE));
        }
        if ((jsonArraycomponents = jsonObj.getAsJsonArray(SERIALIZED_NAME_COMPONENTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_COMPONENTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `components` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMPONENTS).toString()));
            }
            for (int i = 0; i < jsonArraycomponents.size(); ++i) {
                WhatsappMessageTemplateComponentsInner.validateJsonObject(jsonArraycomponents.get(i).getAsJsonObject());
            }
        }
    }

    public static WhatsappMessageTemplate fromJson(String jsonString) throws IOException {
        return (WhatsappMessageTemplate)JSON.getGson().fromJson(jsonString, WhatsappMessageTemplate.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_LANGUAGE);
        openapiFields.add(SERIALIZED_NAME_COMPONENTS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_LANGUAGE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!WhatsappMessageTemplate.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(WhatsappMessageTemplate.class));
            return new TypeAdapter<WhatsappMessageTemplate>(){

                public void write(JsonWriter out, WhatsappMessageTemplate value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public WhatsappMessageTemplate read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    WhatsappMessageTemplate.validateJsonObject(jsonObj);
                    WhatsappMessageTemplate instance = (WhatsappMessageTemplate)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

