/*
 * Decompiled with CFR 0.152.
 */
package com.ycloud.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ycloud.client.JSON;
import com.ycloud.client.model.WhatsappMessageTemplateComponentsInnerParametersInner;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Component object containing the parameters of the message.")
public class WhatsappMessageTemplateComponentsInner {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_SUB_TYPE = "sub_type";
    @SerializedName(value="sub_type")
    private SubTypeEnum subType;
    public static final String SERIALIZED_NAME_INDEX = "index";
    @SerializedName(value="index")
    private Integer index;
    public static final String SERIALIZED_NAME_PARAMETERS = "parameters";
    @SerializedName(value="parameters")
    private List<WhatsappMessageTemplateComponentsInnerParametersInner> parameters = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public WhatsappMessageTemplateComponentsInner type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Describes the component type. One of `header`, `body`, `button`. For text-based templates, we only support the type=body.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public WhatsappMessageTemplateComponentsInner subType(SubTypeEnum subType) {
        this.subType = subType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Type of button to create. `quick_reply`: Refers to a previously created quick reply button that allows for the customer to return a predefined message. `url`: Refers to a previously created button that allows the customer to visit the URL generated by appending the text parameter to the predefined prefix URL in the template.")
    public SubTypeEnum getSubType() {
        return this.subType;
    }

    public void setSubType(SubTypeEnum subType) {
        this.subType = subType;
    }

    public WhatsappMessageTemplateComponentsInner index(Integer index) {
        this.index = index;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Required when `type` = `button`. Not used for the other types. Position index of the button. You can have up to 3 buttons using index values of 0 to 2.")
    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public WhatsappMessageTemplateComponentsInner parameters(List<WhatsappMessageTemplateComponentsInnerParametersInner> parameters) {
        this.parameters = parameters;
        return this;
    }

    public WhatsappMessageTemplateComponentsInner addParametersItem(WhatsappMessageTemplateComponentsInnerParametersInner parametersItem) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<WhatsappMessageTemplateComponentsInnerParametersInner>();
        }
        this.parameters.add(parametersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Required when `type` = `button`. Array of parameter objects with the content of the message. For components of `type` = `button`, see the [button parameter object](https://developers.facebook.com/docs/whatsapp/cloud-api/reference/messages#button-parameter-object).")
    public List<WhatsappMessageTemplateComponentsInnerParametersInner> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<WhatsappMessageTemplateComponentsInnerParametersInner> parameters) {
        this.parameters = parameters;
    }

    public WhatsappMessageTemplateComponentsInner putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WhatsappMessageTemplateComponentsInner whatsappMessageTemplateComponentsInner = (WhatsappMessageTemplateComponentsInner)o;
        return Objects.equals((Object)this.type, (Object)whatsappMessageTemplateComponentsInner.type) && Objects.equals((Object)this.subType, (Object)whatsappMessageTemplateComponentsInner.subType) && Objects.equals(this.index, whatsappMessageTemplateComponentsInner.index) && Objects.equals(this.parameters, whatsappMessageTemplateComponentsInner.parameters) && Objects.equals(this.additionalProperties, whatsappMessageTemplateComponentsInner.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.subType, this.index, this.parameters, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WhatsappMessageTemplateComponentsInner {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    subType: ").append(this.toIndentedString((Object)this.subType)).append("\n");
        sb.append("    index: ").append(this.toIndentedString(this.index)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in WhatsappMessageTemplateComponentsInner is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUB_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_SUB_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `sub_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUB_TYPE).toString()));
        }
        JsonArray jsonArrayparameters = jsonObj.getAsJsonArray(SERIALIZED_NAME_PARAMETERS);
        if (jsonArrayparameters != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PARAMETERS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `parameters` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PARAMETERS).toString()));
            }
            for (int i = 0; i < jsonArrayparameters.size(); ++i) {
                WhatsappMessageTemplateComponentsInnerParametersInner.validateJsonObject(jsonArrayparameters.get(i).getAsJsonObject());
            }
        }
    }

    public static WhatsappMessageTemplateComponentsInner fromJson(String jsonString) throws IOException {
        return (WhatsappMessageTemplateComponentsInner)JSON.getGson().fromJson(jsonString, WhatsappMessageTemplateComponentsInner.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_SUB_TYPE);
        openapiFields.add(SERIALIZED_NAME_INDEX);
        openapiFields.add(SERIALIZED_NAME_PARAMETERS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!WhatsappMessageTemplateComponentsInner.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(WhatsappMessageTemplateComponentsInner.class));
            return new TypeAdapter<WhatsappMessageTemplateComponentsInner>(){

                public void write(JsonWriter out, WhatsappMessageTemplateComponentsInner value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public WhatsappMessageTemplateComponentsInner read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    WhatsappMessageTemplateComponentsInner.validateJsonObject(jsonObj);
                    WhatsappMessageTemplateComponentsInner instance = (WhatsappMessageTemplateComponentsInner)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SubTypeEnum {
        QUICK_REPLY("quick_reply"),
        URL("url");

        private String value;

        private SubTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SubTypeEnum fromValue(String value) {
            for (SubTypeEnum b : SubTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<SubTypeEnum> {
            public void write(JsonWriter jsonWriter, SubTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SubTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SubTypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        HEADER("header"),
        BODY("body"),
        BUTTON("button");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

