/*
 * Decompiled with CFR 0.152.
 */
package com.ycloud.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ycloud.client.JSON;
import com.ycloud.client.model.WhatsappPhoneNumberCodeVerificationStatus;
import com.ycloud.client.model.WhatsappPhoneNumberNameStatus;
import com.ycloud.client.model.WhatsappPhoneNumberQualityRating;
import com.ycloud.client.model.WhatsappPhoneNumberStatus;
import com.ycloud.client.model.WhatsappReviewDecision;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A WhatsApp Business Account (WABA) phone number. See also [WhatsApp Retrieve Phone Numbers](https://developers.facebook.com/docs/whatsapp/business-management-api/manage-phone-numbers).")
public class WhatsappPhoneNumber {
    public static final String SERIALIZED_NAME_PHONE_NUMBER = "phoneNumber";
    @SerializedName(value="phoneNumber")
    private String phoneNumber;
    public static final String SERIALIZED_NAME_DISPLAY_PHONE_NUMBER = "displayPhoneNumber";
    @SerializedName(value="displayPhoneNumber")
    private String displayPhoneNumber;
    public static final String SERIALIZED_NAME_WABA_ID = "wabaId";
    @SerializedName(value="wabaId")
    private String wabaId;
    public static final String SERIALIZED_NAME_QUALITY_RATING = "qualityRating";
    @SerializedName(value="qualityRating")
    private WhatsappPhoneNumberQualityRating qualityRating;
    public static final String SERIALIZED_NAME_MESSAGING_LIMIT = "messagingLimit";
    @SerializedName(value="messagingLimit")
    private String messagingLimit;
    public static final String SERIALIZED_NAME_VERIFIED_NAME = "verifiedName";
    @SerializedName(value="verifiedName")
    private String verifiedName;
    public static final String SERIALIZED_NAME_CODE_VERIFICATION_STATUS = "codeVerificationStatus";
    @SerializedName(value="codeVerificationStatus")
    private WhatsappPhoneNumberCodeVerificationStatus codeVerificationStatus;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private WhatsappPhoneNumberStatus status;
    public static final String SERIALIZED_NAME_NAME_STATUS = "nameStatus";
    @SerializedName(value="nameStatus")
    private WhatsappPhoneNumberNameStatus nameStatus;
    public static final String SERIALIZED_NAME_NEW_NAME_STATUS = "newNameStatus";
    @SerializedName(value="newNameStatus")
    private WhatsappPhoneNumberNameStatus newNameStatus;
    public static final String SERIALIZED_NAME_DECISION = "decision";
    @SerializedName(value="decision")
    private WhatsappReviewDecision decision;
    public static final String SERIALIZED_NAME_REQUESTED_VERIFIED_NAME = "requestedVerifiedName";
    @SerializedName(value="requestedVerifiedName")
    private String requestedVerifiedName;
    public static final String SERIALIZED_NAME_REJECTION_REASON = "rejectionReason";
    @SerializedName(value="rejectionReason")
    private String rejectionReason;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public WhatsappPhoneNumber phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="+16315551111", value="Phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format.")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public WhatsappPhoneNumber displayPhoneNumber(String displayPhoneNumber) {
        this.displayPhoneNumber = displayPhoneNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="+1 631-555-1111", value="Display phone number.")
    public String getDisplayPhoneNumber() {
        return this.displayPhoneNumber;
    }

    public void setDisplayPhoneNumber(String displayPhoneNumber) {
        this.displayPhoneNumber = displayPhoneNumber;
    }

    public WhatsappPhoneNumber wabaId(String wabaId) {
        this.wabaId = wabaId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="whatsapp-business-account-id", value="WhatsApp Business Account ID.")
    public String getWabaId() {
        return this.wabaId;
    }

    public void setWabaId(String wabaId) {
        this.wabaId = wabaId;
    }

    public WhatsappPhoneNumber qualityRating(WhatsappPhoneNumberQualityRating qualityRating) {
        this.qualityRating = qualityRating;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappPhoneNumberQualityRating getQualityRating() {
        return this.qualityRating;
    }

    public void setQualityRating(WhatsappPhoneNumberQualityRating qualityRating) {
        this.qualityRating = qualityRating;
    }

    public WhatsappPhoneNumber messagingLimit(String messagingLimit) {
        this.messagingLimit = messagingLimit;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="TIER_1K", value="Messaging limits determine the maximum number of business-initiated conversations each phone number can start in a rolling 24-hour period. See also [Messaging Limits](https://developers.facebook.com/docs/whatsapp/messaging-limits#messaging-limits). - `TIER_50`: 50 business-initiated conversations in a rolling 24-hour period. - `TIER_250`: 250 business-initiated conversations in a rolling 24-hour period. - `TIER_1K`: 1K business-initiated conversations with unique customers in a rolling 24-hour period. - `TIER_10K`: 10K business-initiated conversations with unique customers in a rolling 24-hour period. - `TIER_100K`: 100K business-initiated conversations with unique customers in a rolling 24-hour period. - `TIER_UNLIMITED`: An unlimited number of business-initiated conversations in a rolling 24-hour period.")
    public String getMessagingLimit() {
        return this.messagingLimit;
    }

    public void setMessagingLimit(String messagingLimit) {
        this.messagingLimit = messagingLimit;
    }

    public WhatsappPhoneNumber verifiedName(String verifiedName) {
        this.verifiedName = verifiedName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="John\u2019s Cake Shop", value="Verified name.")
    public String getVerifiedName() {
        return this.verifiedName;
    }

    public void setVerifiedName(String verifiedName) {
        this.verifiedName = verifiedName;
    }

    public WhatsappPhoneNumber codeVerificationStatus(WhatsappPhoneNumberCodeVerificationStatus codeVerificationStatus) {
        this.codeVerificationStatus = codeVerificationStatus;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappPhoneNumberCodeVerificationStatus getCodeVerificationStatus() {
        return this.codeVerificationStatus;
    }

    public void setCodeVerificationStatus(WhatsappPhoneNumberCodeVerificationStatus codeVerificationStatus) {
        this.codeVerificationStatus = codeVerificationStatus;
    }

    public WhatsappPhoneNumber status(WhatsappPhoneNumberStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappPhoneNumberStatus getStatus() {
        return this.status;
    }

    public void setStatus(WhatsappPhoneNumberStatus status) {
        this.status = status;
    }

    public WhatsappPhoneNumber nameStatus(WhatsappPhoneNumberNameStatus nameStatus) {
        this.nameStatus = nameStatus;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappPhoneNumberNameStatus getNameStatus() {
        return this.nameStatus;
    }

    public void setNameStatus(WhatsappPhoneNumberNameStatus nameStatus) {
        this.nameStatus = nameStatus;
    }

    public WhatsappPhoneNumber newNameStatus(WhatsappPhoneNumberNameStatus newNameStatus) {
        this.newNameStatus = newNameStatus;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappPhoneNumberNameStatus getNewNameStatus() {
        return this.newNameStatus;
    }

    public void setNewNameStatus(WhatsappPhoneNumberNameStatus newNameStatus) {
        this.newNameStatus = newNameStatus;
    }

    public WhatsappPhoneNumber decision(WhatsappReviewDecision decision) {
        this.decision = decision;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WhatsappReviewDecision getDecision() {
        return this.decision;
    }

    public void setDecision(WhatsappReviewDecision decision) {
        this.decision = decision;
    }

    public WhatsappPhoneNumber requestedVerifiedName(String requestedVerifiedName) {
        this.requestedVerifiedName = requestedVerifiedName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Last requested verified name. See [Phone Number Name Update](https://developers.facebook.com/docs/graph-api/webhooks/reference/whatsapp-business-account/#phone_number_name_update).")
    public String getRequestedVerifiedName() {
        return this.requestedVerifiedName;
    }

    public void setRequestedVerifiedName(String requestedVerifiedName) {
        this.requestedVerifiedName = requestedVerifiedName;
    }

    public WhatsappPhoneNumber rejectionReason(String rejectionReason) {
        this.rejectionReason = rejectionReason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Rejection reason. See [Phone Number Name Update](https://developers.facebook.com/docs/graph-api/webhooks/reference/whatsapp-business-account/#phone_number_name_update).")
    public String getRejectionReason() {
        return this.rejectionReason;
    }

    public void setRejectionReason(String rejectionReason) {
        this.rejectionReason = rejectionReason;
    }

    public WhatsappPhoneNumber putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WhatsappPhoneNumber whatsappPhoneNumber = (WhatsappPhoneNumber)o;
        return Objects.equals(this.phoneNumber, whatsappPhoneNumber.phoneNumber) && Objects.equals(this.displayPhoneNumber, whatsappPhoneNumber.displayPhoneNumber) && Objects.equals(this.wabaId, whatsappPhoneNumber.wabaId) && Objects.equals((Object)this.qualityRating, (Object)whatsappPhoneNumber.qualityRating) && Objects.equals(this.messagingLimit, whatsappPhoneNumber.messagingLimit) && Objects.equals(this.verifiedName, whatsappPhoneNumber.verifiedName) && Objects.equals((Object)this.codeVerificationStatus, (Object)whatsappPhoneNumber.codeVerificationStatus) && Objects.equals((Object)this.status, (Object)whatsappPhoneNumber.status) && Objects.equals((Object)this.nameStatus, (Object)whatsappPhoneNumber.nameStatus) && Objects.equals((Object)this.newNameStatus, (Object)whatsappPhoneNumber.newNameStatus) && Objects.equals((Object)this.decision, (Object)whatsappPhoneNumber.decision) && Objects.equals(this.requestedVerifiedName, whatsappPhoneNumber.requestedVerifiedName) && Objects.equals(this.rejectionReason, whatsappPhoneNumber.rejectionReason) && Objects.equals(this.additionalProperties, whatsappPhoneNumber.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.phoneNumber, this.displayPhoneNumber, this.wabaId, this.qualityRating, this.messagingLimit, this.verifiedName, this.codeVerificationStatus, this.status, this.nameStatus, this.newNameStatus, this.decision, this.requestedVerifiedName, this.rejectionReason, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WhatsappPhoneNumber {\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    displayPhoneNumber: ").append(this.toIndentedString(this.displayPhoneNumber)).append("\n");
        sb.append("    wabaId: ").append(this.toIndentedString(this.wabaId)).append("\n");
        sb.append("    qualityRating: ").append(this.toIndentedString((Object)this.qualityRating)).append("\n");
        sb.append("    messagingLimit: ").append(this.toIndentedString(this.messagingLimit)).append("\n");
        sb.append("    verifiedName: ").append(this.toIndentedString(this.verifiedName)).append("\n");
        sb.append("    codeVerificationStatus: ").append(this.toIndentedString((Object)this.codeVerificationStatus)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    nameStatus: ").append(this.toIndentedString((Object)this.nameStatus)).append("\n");
        sb.append("    newNameStatus: ").append(this.toIndentedString((Object)this.newNameStatus)).append("\n");
        sb.append("    decision: ").append(this.toIndentedString((Object)this.decision)).append("\n");
        sb.append("    requestedVerifiedName: ").append(this.toIndentedString(this.requestedVerifiedName)).append("\n");
        sb.append("    rejectionReason: ").append(this.toIndentedString(this.rejectionReason)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in WhatsappPhoneNumber is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PHONE_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_PHONE_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `phoneNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PHONE_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DISPLAY_PHONE_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_DISPLAY_PHONE_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `displayPhoneNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DISPLAY_PHONE_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_WABA_ID) != null && !jsonObj.get(SERIALIZED_NAME_WABA_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `wabaId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_WABA_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MESSAGING_LIMIT) != null && !jsonObj.get(SERIALIZED_NAME_MESSAGING_LIMIT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `messagingLimit` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MESSAGING_LIMIT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VERIFIED_NAME) != null && !jsonObj.get(SERIALIZED_NAME_VERIFIED_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `verifiedName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VERIFIED_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REQUESTED_VERIFIED_NAME) != null && !jsonObj.get(SERIALIZED_NAME_REQUESTED_VERIFIED_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `requestedVerifiedName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REQUESTED_VERIFIED_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REJECTION_REASON) != null && !jsonObj.get(SERIALIZED_NAME_REJECTION_REASON).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `rejectionReason` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REJECTION_REASON).toString()));
        }
    }

    public static WhatsappPhoneNumber fromJson(String jsonString) throws IOException {
        return (WhatsappPhoneNumber)JSON.getGson().fromJson(jsonString, WhatsappPhoneNumber.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_PHONE_NUMBER);
        openapiFields.add(SERIALIZED_NAME_DISPLAY_PHONE_NUMBER);
        openapiFields.add(SERIALIZED_NAME_WABA_ID);
        openapiFields.add(SERIALIZED_NAME_QUALITY_RATING);
        openapiFields.add(SERIALIZED_NAME_MESSAGING_LIMIT);
        openapiFields.add(SERIALIZED_NAME_VERIFIED_NAME);
        openapiFields.add(SERIALIZED_NAME_CODE_VERIFICATION_STATUS);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_NEW_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_DECISION);
        openapiFields.add(SERIALIZED_NAME_REQUESTED_VERIFIED_NAME);
        openapiFields.add(SERIALIZED_NAME_REJECTION_REASON);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!WhatsappPhoneNumber.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(WhatsappPhoneNumber.class));
            return new TypeAdapter<WhatsappPhoneNumber>(){

                public void write(JsonWriter out, WhatsappPhoneNumber value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public WhatsappPhoneNumber read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    WhatsappPhoneNumber.validateJsonObject(jsonObj);
                    WhatsappPhoneNumber instance = (WhatsappPhoneNumber)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

