/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff;

import de.danielbechler.diff.Differ;
import de.danielbechler.diff.DifferDelegator;
import de.danielbechler.diff.Instances;
import de.danielbechler.diff.MapNodeFactory;
import de.danielbechler.diff.NodeInspector;
import de.danielbechler.diff.TestOnly;
import de.danielbechler.diff.accessor.Accessor;
import de.danielbechler.diff.node.MapNode;
import de.danielbechler.diff.node.Node;
import de.danielbechler.util.Assert;
import de.danielbechler.util.Collections;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MapDiffer
implements Differ<MapNode> {
    private final DifferDelegator delegator;
    private final NodeInspector nodeInspector;
    private MapNodeFactory mapNodeFactory = new MapNodeFactory();

    public MapDiffer(DifferDelegator delegator, NodeInspector nodeInspector) {
        Assert.notNull(delegator, "delegator");
        Assert.notNull(nodeInspector, "nodeInspector");
        this.delegator = delegator;
        this.nodeInspector = nodeInspector;
    }

    @Override
    public final MapNode compare(Node parentNode, Instances instances) {
        MapNode mapNode = this.mapNodeFactory.createMapNode(parentNode, instances);
        MapDiffer.indexAll(mapNode, instances);
        if (this.nodeInspector.isIgnored(mapNode)) {
            mapNode.setState(Node.State.IGNORED);
        } else if (this.nodeInspector.isEqualsOnly(mapNode)) {
            if (instances.areEqual()) {
                mapNode.setState(Node.State.UNTOUCHED);
            } else {
                mapNode.setState(Node.State.CHANGED);
            }
        } else if (instances.hasBeenAdded()) {
            this.compareEntries(mapNode, instances, instances.getWorking(Map.class).keySet());
            mapNode.setState(Node.State.ADDED);
        } else if (instances.hasBeenRemoved()) {
            this.compareEntries(mapNode, instances, instances.getBase(Map.class).keySet());
            mapNode.setState(Node.State.REMOVED);
        } else if (instances.areSame()) {
            mapNode.setState(Node.State.UNTOUCHED);
        } else {
            this.compareEntries(mapNode, instances, MapDiffer.findAddedKeys(instances));
            this.compareEntries(mapNode, instances, MapDiffer.findRemovedKeys(instances));
            this.compareEntries(mapNode, instances, MapDiffer.findKnownKeys(instances));
        }
        return mapNode;
    }

    private static void indexAll(MapNode node, Instances instances) {
        MapDiffer.indexKeys(node, instances.getWorking(Map.class));
        MapDiffer.indexKeys(node, instances.getBase(Map.class));
        MapDiffer.indexKeys(node, instances.getFresh(Map.class));
    }

    private static void indexKeys(MapNode mapNode, Map map) {
        if (map != null) {
            Set keys = map.keySet();
            for (Object key : keys) {
                mapNode.indexKey(key);
            }
        }
    }

    private void compareEntries(MapNode mapNode, Instances mapInstances, Iterable<?> keys) {
        for (Object key : keys) {
            Node node = this.compareEntry(mapNode, mapInstances, key);
            if (!this.nodeInspector.isReturnable(node)) continue;
            mapNode.addChild(node);
        }
    }

    private Node compareEntry(MapNode mapNode, Instances mapInstances, Object key) {
        Accessor mapEntryAccessor = mapNode.accessorForKey(key);
        Instances mapEntryInstances = mapInstances.access(mapEntryAccessor);
        return this.delegator.delegate(mapNode, mapEntryInstances);
    }

    private static Collection<?> findAddedKeys(Instances instances) {
        Set source = instances.getWorking(Map.class).keySet();
        Set filter = instances.getBase(Map.class).keySet();
        return Collections.filteredCopyOf(source, filter);
    }

    private static Collection<?> findRemovedKeys(Instances instances) {
        Set source = instances.getBase(Map.class).keySet();
        Set filter = instances.getWorking(Map.class).keySet();
        return Collections.filteredCopyOf(source, filter);
    }

    private static Iterable<?> findKnownKeys(Instances instances) {
        Set keys = instances.getWorking(Map.class).keySet();
        Set changed = Collections.setOf(keys);
        changed.removeAll(MapDiffer.findAddedKeys(instances));
        changed.removeAll(MapDiffer.findRemovedKeys(instances));
        return changed;
    }

    @TestOnly
    public void setMapNodeFactory(MapNodeFactory mapNodeFactory) {
        this.mapNodeFactory = mapNodeFactory;
    }
}

