/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.visitor;

import de.danielbechler.diff.node.Node;
import de.danielbechler.diff.path.PropertyPath;
import de.danielbechler.diff.visitor.Visit;
import de.danielbechler.util.Strings;

public class PrintingVisitor
implements Node.Visitor {
    private final Object working;
    private final Object base;

    public PrintingVisitor(Object working, Object base) {
        this.base = base;
        this.working = working;
    }

    public void accept(Node node, Visit visit) {
        if (this.filter(node)) {
            String text = this.differenceToString(node, this.base, this.working);
            this.print(text);
        }
    }

    protected boolean filter(Node node) {
        return node.isRootNode() && !node.hasChanges() || node.hasChanges() && node.getChildren().isEmpty();
    }

    protected void print(String text) {
        System.out.println(text);
    }

    protected String differenceToString(Node node, Object base, Object modified) {
        PropertyPath propertyPath = node.getPropertyPath();
        String stateMessage = this.translateState(node.getState(), node.canonicalGet(base), node.canonicalGet(modified));
        String propertyMessage = String.format("Property at path '%s' %s", propertyPath, stateMessage);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(propertyMessage);
        if (node.isCircular()) {
            stringBuilder.append(" (Circular reference detected: The property has already been processed at another position.)");
        }
        return stringBuilder.toString();
    }

    private String translateState(Node.State state, Object base, Object modified) {
        if (state == Node.State.IGNORED) {
            return "has been ignored";
        }
        if (state == Node.State.CHANGED) {
            return String.format("has changed from [ %s ] to [ %s ]", Strings.toSingleLineString(base), Strings.toSingleLineString(modified));
        }
        if (state == Node.State.ADDED) {
            return String.format("has been added => [ %s ]", Strings.toSingleLineString(modified));
        }
        if (state == Node.State.REMOVED) {
            return String.format("with value [ %s ] has been removed", Strings.toSingleLineString(base));
        }
        if (state == Node.State.UNTOUCHED) {
            return "has not changed";
        }
        if (state == Node.State.CIRCULAR) {
            return "has already been processed at another position. (Circular reference!)";
        }
        return String.valueOf('(') + state.name() + ')';
    }
}

