/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.visitor;

import de.danielbechler.diff.node.Node;
import de.danielbechler.diff.path.PropertyPath;
import de.danielbechler.diff.visitor.PrintingVisitor;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToMapPrintingVisitor
extends PrintingVisitor {
    private final Map<PropertyPath, String> messages = new LinkedHashMap<PropertyPath, String>();

    public ToMapPrintingVisitor(Object working, Object base) {
        super(working, base);
    }

    @Override
    protected void print(String text) {
    }

    @Override
    protected String differenceToString(Node node, Object base, Object modified) {
        String text = super.differenceToString(node, base, modified);
        this.messages.put(node.getPropertyPath(), text);
        return text;
    }

    public void clear() {
        this.messages.clear();
    }

    public Map<PropertyPath, String> getMessages() {
        return this.messages;
    }

    public String getMessage(PropertyPath path) {
        return this.messages.get(path);
    }

    public boolean hasMessages() {
        return !this.messages.isEmpty();
    }

    public String getMessagesAsString() {
        StringBuilder sb = new StringBuilder();
        for (String message : this.messages.values()) {
            sb.append(message).append('\n');
        }
        return sb.toString();
    }

    public String toString() {
        return this.getMessagesAsString();
    }
}

