/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff;

import de.danielbechler.diff.NodeInspector;
import de.danielbechler.diff.annotation.ObjectDiffEqualsOnlyType;
import de.danielbechler.diff.node.Node;
import de.danielbechler.diff.path.ClassAndMethod;
import de.danielbechler.diff.path.PropertyPath;
import de.danielbechler.diff.path.PropertyPathAndMethod;
import de.danielbechler.util.Assert;
import de.danielbechler.util.Classes;
import de.danielbechler.util.Collections;
import de.danielbechler.util.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration
implements NodeInspector {
    private final Collection<String> includedCategories = new TreeSet<String>();
    private final Collection<String> excludedCategories = new TreeSet<String>();
    private final Collection<PropertyPath> includedProperties = new HashSet<PropertyPath>(10);
    private final Collection<PropertyPath> excludedProperties = new HashSet<PropertyPath>(10);
    private final Collection<PropertyPath> equalsOnlyProperties = new LinkedHashSet<PropertyPath>(10);
    private final Collection<PropertyPathAndMethod> equalsOnlyValueProviderMethods = new LinkedHashSet<PropertyPathAndMethod>(10);
    private final Collection<Class<?>> compareToOnlyTypes = new LinkedHashSet(10);
    private final Collection<Class<?>> equalsOnlyTypes = new LinkedHashSet(10);
    private final Collection<ClassAndMethod> equalsOnlyValueProviderTypes = new LinkedHashSet<ClassAndMethod>(10);
    private boolean returnUnchangedNodes = false;
    private boolean returnIgnoredNodes = false;
    private boolean returnCircularNodes = true;
    private boolean returnChildrenOfAddedNodes = false;
    private boolean returnChildrenOfRemovedNodes = false;
    private CircularReferenceMatchingMode circularReferenceMatchingMode = CircularReferenceMatchingMode.EQUALITY_OPERATOR;
    private PrimitiveDefaultValueMode treatPrimitivesAs = PrimitiveDefaultValueMode.UNASSIGNED;

    public Configuration withCategory(String category) {
        this.includedCategories.addAll(Arrays.asList(category));
        return this;
    }

    public Configuration withoutCategory(String ... category) {
        this.excludedCategories.addAll(Arrays.asList(category));
        return this;
    }

    public Configuration withPropertyPath(PropertyPath propertyPath) {
        this.includedProperties.add(propertyPath);
        return this;
    }

    public Configuration withoutProperty(PropertyPath propertyPath) {
        this.excludedProperties.add(propertyPath);
        return this;
    }

    public Configuration withCompareToOnlyType(Class<?> type) {
        this.compareToOnlyTypes.add(type);
        return this;
    }

    public Configuration withEqualsOnlyType(Class<?> type) {
        this.equalsOnlyTypes.add(type);
        return this;
    }

    public Configuration withEqualsOnlyProperty(PropertyPath propertyPath) {
        this.equalsOnlyProperties.add(propertyPath);
        return this;
    }

    public Configuration withEqualsOnlyValueProviderMethod(PropertyPath propertyPath, String methodName) {
        this.equalsOnlyValueProviderMethods.add(new PropertyPathAndMethod(propertyPath, methodName));
        return this;
    }

    public Configuration withEqualsOnlyValueProviderMethod(PropertyPathAndMethod propertyPathEqualsMethod) {
        this.equalsOnlyValueProviderMethods.add(propertyPathEqualsMethod);
        return this;
    }

    public Configuration withEqualsOnlyValueProviderMethod(Class<?> type, String method) {
        this.equalsOnlyValueProviderTypes.add(new ClassAndMethod(type, method));
        return this;
    }

    public Configuration withEqualsOnlyValueProviderMethod(ClassAndMethod classAndMethod) {
        this.equalsOnlyValueProviderTypes.add(classAndMethod);
        return this;
    }

    public Configuration withIgnoredNodes() {
        this.returnIgnoredNodes = true;
        return this;
    }

    public Configuration withoutIgnoredNodes() {
        this.returnIgnoredNodes = false;
        return this;
    }

    public Configuration withUntouchedNodes() {
        this.returnUnchangedNodes = true;
        return this;
    }

    public Configuration withoutUntouchedNodes() {
        this.returnUnchangedNodes = false;
        return this;
    }

    public Configuration withCircularNodes() {
        this.returnCircularNodes = true;
        return this;
    }

    public Configuration withoutCircularNodes() {
        this.returnCircularNodes = false;
        return this;
    }

    public Configuration withChildrenOfAddedNodes() {
        this.returnChildrenOfAddedNodes = true;
        return this;
    }

    public Configuration withoutChildrenOfAddedNodes() {
        this.returnChildrenOfAddedNodes = false;
        return this;
    }

    public Configuration withChildrenOfRemovedNodes() {
        this.returnChildrenOfRemovedNodes = true;
        return this;
    }

    public Configuration withoutChildrenOfRemovedNodes() {
        this.returnChildrenOfRemovedNodes = false;
        return this;
    }

    public Configuration treatPrimitiveDefaultValuesAs(PrimitiveDefaultValueMode mode) {
        this.treatPrimitivesAs = mode;
        return this;
    }

    public PrimitiveDefaultValueMode getPrimitiveDefaultValueMode() {
        return this.treatPrimitivesAs;
    }

    public CircularReferenceMatchingMode getCircularReferenceMatchingMode() {
        return this.circularReferenceMatchingMode;
    }

    public void matchCircularReferencesUsing(CircularReferenceMatchingMode circularReferenceMatchingMode) {
        Assert.notNull((Object)circularReferenceMatchingMode, "circularReferenceMatchingMode");
        this.circularReferenceMatchingMode = circularReferenceMatchingMode;
    }

    @Override
    public boolean isIgnored(Node node) {
        return node.isIgnored() || !this.isIncluded(node) || this.isExcluded(node);
    }

    @Override
    public boolean isIncluded(Node node) {
        if (node.isRootNode()) {
            return true;
        }
        if (this.includedCategories.isEmpty() && this.includedProperties.isEmpty()) {
            return true;
        }
        if (Collections.containsAny(node.getCategories(), this.includedCategories)) {
            return true;
        }
        if (this.includedProperties.contains(node.getPropertyPath())) {
            return true;
        }
        for (PropertyPath includedProperty : this.includedProperties) {
            if (!includedProperty.isParentOf(node.getPropertyPath())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isExcluded(Node node) {
        if (this.excludedProperties.contains(node.getPropertyPath())) {
            return true;
        }
        return Collections.containsAny(node.getCategories(), this.excludedCategories);
    }

    @Override
    public boolean isCompareToOnly(Node node) {
        Class<?> propertyType = node.getType();
        if (propertyType != null) {
            if (this.compareToOnlyTypes.contains(propertyType) && Comparable.class.isAssignableFrom(propertyType)) {
                return true;
            }
            if (Classes.isComparableType(propertyType)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isEqualsOnly(Node node) {
        Class<?> propertyType = node.getType();
        if (propertyType != null) {
            if (propertyType.getAnnotation(ObjectDiffEqualsOnlyType.class) != null) {
                return true;
            }
            if (this.equalsOnlyTypes.contains(propertyType)) {
                return true;
            }
            if (Classes.isSimpleType(propertyType)) {
                return true;
            }
        }
        if (node.isEqualsOnly()) {
            return true;
        }
        return this.equalsOnlyProperties.contains(node.getPropertyPath());
    }

    @Override
    public boolean hasEqualsOnlyValueProviderMethod(Node node) {
        return Strings.hasText(this.getEqualsOnlyValueProviderMethod(node));
    }

    @Override
    public String getEqualsOnlyValueProviderMethod(Node node) {
        Class<?> propertyType = node.getType();
        if (propertyType != null) {
            ObjectDiffEqualsOnlyType annotation = propertyType.getAnnotation(ObjectDiffEqualsOnlyType.class);
            if (annotation != null) {
                return annotation.valueProviderMethod();
            }
            ClassAndMethod applicable = this.findEqualsOnlyValueProviderMethodForClass(propertyType);
            if (applicable != null) {
                return applicable.getMethod();
            }
        }
        if (node.hasEqualsOnlyValueProviderMethod()) {
            return node.getEqualsOnlyValueProviderMethod();
        }
        PropertyPathAndMethod applicable = this.findEqualsOnlyValueProviderMethodForPath(node.getPropertyPath());
        if (applicable != null) {
            return applicable.getMethod();
        }
        return null;
    }

    private ClassAndMethod findEqualsOnlyValueProviderMethodForClass(Class<?> clazz) {
        for (ClassAndMethod propertyPathEqualsOnValueProviderType : this.equalsOnlyValueProviderTypes) {
            if (!clazz.equals(propertyPathEqualsOnValueProviderType.getClazz())) continue;
            return propertyPathEqualsOnValueProviderType;
        }
        return null;
    }

    private PropertyPathAndMethod findEqualsOnlyValueProviderMethodForPath(PropertyPath propertyPath) {
        for (PropertyPathAndMethod propertyPathEqualsOnValueProviderMethod : this.equalsOnlyValueProviderMethods) {
            if (!propertyPath.equals(propertyPathEqualsOnValueProviderMethod.getPropertyPath())) continue;
            return propertyPathEqualsOnValueProviderMethod;
        }
        return null;
    }

    @Override
    public boolean isReturnable(Node node) {
        if (node.isIgnored()) {
            return this.returnIgnoredNodes;
        }
        if (node.isCircular()) {
            return this.returnCircularNodes;
        }
        if (node.isUntouched()) {
            if (node.hasChanges()) {
                return true;
            }
            if (node.hasChildren()) {
                return true;
            }
            return this.returnUnchangedNodes;
        }
        return true;
    }

    @Override
    public boolean isIntrospectible(Node node) {
        if (node.isAdded()) {
            return this.returnChildrenOfAddedNodes;
        }
        if (node.isRemoved()) {
            return this.returnChildrenOfRemovedNodes;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CircularReferenceMatchingMode {
        EQUALITY_OPERATOR,
        EQUALS_METHOD;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PrimitiveDefaultValueMode {
        ASSIGNED,
        UNASSIGNED;

    }
}

