/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.introspection;

import de.danielbechler.diff.access.PropertyAwareAccessor;
import de.danielbechler.diff.introspection.Introspector;
import de.danielbechler.diff.introspection.PropertyAccessor;
import de.danielbechler.util.Assert;
import de.danielbechler.util.Exceptions;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardIntrospector
implements Introspector {
    @Override
    public Iterable<PropertyAwareAccessor> introspect(Class<?> type) {
        Assert.notNull(type, "type");
        try {
            return this.internalIntrospect(type);
        }
        catch (IntrospectionException e) {
            throw Exceptions.escalate(e);
        }
    }

    private Iterable<PropertyAwareAccessor> internalIntrospect(Class<?> type) throws IntrospectionException {
        PropertyDescriptor[] descriptors = this.getBeanInfo(type).getPropertyDescriptors();
        ArrayList<PropertyAwareAccessor> accessors = new ArrayList<PropertyAwareAccessor>(descriptors.length);
        PropertyDescriptor[] propertyDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor descriptor = propertyDescriptorArray[n2];
            if (!StandardIntrospector.shouldSkip(descriptor)) {
                String propertyName = descriptor.getName();
                Method readMethod = descriptor.getReadMethod();
                Method writeMethod = descriptor.getWriteMethod();
                accessors.add(new PropertyAccessor(propertyName, readMethod, writeMethod));
            }
            ++n2;
        }
        return accessors;
    }

    protected BeanInfo getBeanInfo(Class<?> type) throws IntrospectionException {
        return java.beans.Introspector.getBeanInfo(type);
    }

    private static boolean shouldSkip(PropertyDescriptor descriptor) {
        if (descriptor.getName().equals("class")) {
            return true;
        }
        if (descriptor.getName().equals("metaClass")) {
            return true;
        }
        return descriptor.getReadMethod() == null;
    }
}

