/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.document.processor.dia;

import de.srsoftware.document.api.Document;
import de.srsoftware.document.processor.FileProcessor;
import java.util.List;
import java.util.Map;

public class DiaDoc
extends FileProcessor {
    private static final String SOFTWARE = "dia";
    private final String extension;
    private final String mime;
    private final Document precursor;

    public DiaDoc(String mime, String extension, Document precursor) {
        this.mime = mime;
        this.extension = extension;
        this.precursor = precursor;
    }

    @Override
    protected List<String> command(Map<String, Object> data) {
        return List.of(SOFTWARE, "--export", this.name(), this.precursor.name());
    }

    public String description() {
        return "%s rendered from %s".formatted(this.name(), this.precursor.name());
    }

    public String id() {
        return this.precursor.id().replace(".dia", "." + this.extension);
    }

    public String mimeType() {
        return this.mime;
    }

    @Override
    public List<Document> precursors() {
        return List.of(this.precursor);
    }

    @Override
    public String software() {
        return SOFTWARE;
    }
}

