/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.document.processor.dia;

import de.srsoftware.document.api.Document;
import de.srsoftware.document.api.DocumentFactory;
import de.srsoftware.document.api.DocumentRegistry;
import de.srsoftware.document.processor.dia.DiaDoc;
import java.util.stream.Stream;

public class DiaFactory
implements DocumentFactory {
    private DocumentRegistry registry;

    private Stream<Document> createGenerator(Document dia) {
        DiaDoc bmp = new DiaDoc("image/bitmap", "bmp", dia);
        DiaDoc jpg = new DiaDoc("image/jpeg", "jpeg", dia);
        DiaDoc pdf = new DiaDoc("image/pdf", "pdf", dia);
        DiaDoc png = new DiaDoc("image/png", "png", dia);
        DiaDoc svg = new DiaDoc("image/svg", "svg", dia);
        return Stream.of(bmp, jpg, pdf, png, svg);
    }

    public String description() {
        return "This factory provides rendering of DIA documents to various formats.";
    }

    public Stream<Document> documents() {
        return this.registry.documents().filter(document -> "image/dia".equals(document.mimeType())).flatMap(this::createGenerator);
    }

    public DiaFactory setRegistry(DocumentRegistry registry) {
        super.setRegistry(registry);
        this.registry = registry;
        return this;
    }
}

