/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.document.processor.latex;

import de.srsoftware.document.api.Document;
import de.srsoftware.document.processor.FileProcessor;
import java.io.File;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.List;
import java.util.Map;

public abstract class LatexDoc
extends FileProcessor {
    private static final String SOFTWARE = "lualatex";

    @Override
    protected List<String> command(Map<String, Object> data) {
        return List.of(SOFTWARE, "--synctex=1", "--interaction=nonstopmode", this.source().name());
    }

    public String description() {
        return MessageFormat.format("PDF compiled from \"{0}\" via lualatex", this.source().name());
    }

    public String id() {
        return new File(this.source().id()).getName() + ".pdf";
    }

    public String mimeType() {
        return "image/pdf";
    }

    public String name() {
        String sourceFilename = new File(this.source().id()).getName();
        if (sourceFilename.endsWith(".tex")) {
            return sourceFilename.substring(0, sourceFilename.length() - 3) + "pdf";
        }
        return sourceFilename;
    }

    @Override
    public String software() {
        return SOFTWARE;
    }

    protected abstract Document source();

    @Override
    public Duration timeout() {
        return Duration.ofSeconds(30L);
    }
}

