/*
 * Decompiled with CFR 0.152.
 */
package de.srsoftware.document.processor.weasyprint;

import de.srsoftware.document.api.Document;
import de.srsoftware.document.api.DocumentFactory;
import de.srsoftware.document.api.DocumentRegistry;
import de.srsoftware.document.processor.weasyprint.WeasyDoc;
import java.util.List;
import java.util.stream.Stream;

public class WeasyFactory
implements DocumentFactory {
    private DocumentRegistry registry;

    private Document createGenerator(final Document html) {
        return new WeasyDoc(this){

            @Override
            protected Document source() {
                return html;
            }

            @Override
            public List<Document> precursors() {
                return List.of(html);
            }
        };
    }

    public Stream<Document> documents() {
        return this.registry.documents().filter(document -> "text/html".equals(document.mimeType())).map(this::createGenerator);
    }

    public String description() {
        return "Creates PDF files from HTML files";
    }

    public String id() {
        return "";
    }

    public WeasyFactory setRegistry(DocumentRegistry registry) {
        super.setRegistry(registry);
        this.registry = registry;
        return this;
    }
}

