/*
 * Decompiled with CFR 0.152.
 */
package io.pdfapi.client.http;

import io.pdfapi.client.http.AbstractHttpClient;
import io.pdfapi.client.http.HttpResponse;
import io.pdfapi.client.http.StreamingHttpResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RestTemplateHttpClient
extends AbstractHttpClient {
    private final RestTemplate restTemplate;

    public RestTemplateHttpClient() {
        this.restTemplate = new RestTemplate();
    }

    public RestTemplateHttpClient(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    @Override
    protected CompletableFuture<HttpResponse> executePost(String url, Map<String, String> headers, String jsonBody) {
        return CompletableFuture.supplyAsync(() -> {
            HttpHeaders httpHeaders = this.createHeaders(headers);
            httpHeaders.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity entity = new HttpEntity((Object)jsonBody, (MultiValueMap)httpHeaders);
            return (HttpResponse)this.restTemplate.execute(url, HttpMethod.POST, request -> {
                request.getHeaders().putAll((Map)entity.getHeaders());
                request.getBody().write(jsonBody.getBytes());
            }, response -> new StreamingHttpResponse(response.getStatusCode().value(), RestTemplateHttpClient.readContent(response), (AutoCloseable)response, this.mapHeaders(response.getHeaders())), new Object[0]);
        });
    }

    @Override
    protected CompletableFuture<HttpResponse> executePost(String url, Map<String, String> headers, final String fileName, InputStream content, String contentType, String partName) {
        return CompletableFuture.supplyAsync(() -> {
            HttpHeaders httpHeaders = this.createHeaders(headers);
            httpHeaders.setContentType(MediaType.MULTIPART_FORM_DATA);
            LinkedMultiValueMap body = new LinkedMultiValueMap();
            body.add((Object)partName, (Object)new InputStreamResource(content){

                public String getFilename() {
                    return fileName;
                }

                public long contentLength() {
                    return -1L;
                }
            });
            HttpEntity entity = new HttpEntity((Object)body, (MultiValueMap)httpHeaders);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, entity, byte[].class, new Object[0]);
            ByteArrayInputStream bodyData = Optional.ofNullable((byte[])response.getBody()).map(ByteArrayInputStream::new).orElse(null);
            return new StreamingHttpResponse(response.getStatusCodeValue(), bodyData, null, (Map<String, List<String>>)response.getHeaders());
        });
    }

    @Override
    protected CompletableFuture<HttpResponse> executeGet(String url, Map<String, String> headers) {
        return CompletableFuture.supplyAsync(() -> {
            HttpHeaders httpHeaders = this.createHeaders(headers);
            HttpEntity entity = new HttpEntity((MultiValueMap)httpHeaders);
            return (HttpResponse)this.restTemplate.execute(url, HttpMethod.GET, request -> request.getHeaders().putAll((Map)entity.getHeaders()), response -> new StreamingHttpResponse(response.getStatusCode().value(), RestTemplateHttpClient.readContent(response), (AutoCloseable)response, this.mapHeaders(response.getHeaders())), new Object[0]);
        });
    }

    @NotNull
    private static InputStream readContent(ClientHttpResponse response) throws IOException {
        try (InputStream content = response.getBody();){
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(content.readAllBytes());
            return byteArrayInputStream;
        }
    }

    private HttpHeaders createHeaders(Map<String, String> headers) {
        HttpHeaders httpHeaders = new HttpHeaders();
        headers.forEach((arg_0, arg_1) -> ((HttpHeaders)httpHeaders).add(arg_0, arg_1));
        return httpHeaders;
    }

    @Override
    protected void closeInternal() {
    }

    private Map<String, List<String>> mapHeaders(HttpHeaders headers) {
        return headers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

