/*
 * Decompiled with CFR 0.152.
 */
package dk.nversion.copybook.codegen;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class JavaSyntaxChecker {
    static JavaCompiler javac = ToolProvider.getSystemJavaCompiler();
    static Pattern re_packageName = Pattern.compile("^.*?package\\s*([^\\s;]+)", 32);
    static Pattern re_className = Pattern.compile("^.*?\\s(?:class|@interface|enum)\\s*([^\\s]+)", 32);

    public static List<String> check(List<String> sources) throws Exception {
        ArrayList<StringSourceCode> stringSourceCodes = new ArrayList<StringSourceCode>();
        for (String source : sources) {
            Matcher classNameMatcher;
            String packageName = "";
            Matcher packageNameMatcher = re_packageName.matcher(source);
            if (packageNameMatcher.find()) {
                packageName = packageNameMatcher.group(1) + ".";
            }
            if (!(classNameMatcher = re_className.matcher(source)).find()) continue;
            stringSourceCodes.add(new StringSourceCode(packageName + classNameMatcher.group(1), source));
        }
        StandardJavaFileManager fileManager = javac.getStandardFileManager(null, null, StandardCharsets.UTF_8);
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        JavaCompiler.CompilationTask task = javac.getTask(null, null, diagnostics, null, null, stringSourceCodes);
        task.call();
        ArrayList<String> errors = new ArrayList<String>();
        for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
            errors.add(diagnostic.getLineNumber() + ":" + diagnostic.getPosition() + " : " + diagnostic.getMessage(null) + " : " + diagnostic.getSource());
        }
        return errors;
    }

    private static class StringSourceCode
    extends SimpleJavaFileObject {
        private String contents = null;

        public StringSourceCode(String className, String contents) throws Exception {
            super(URI.create("string:///" + className.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.contents = contents;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            return this.contents;
        }
    }
}

