/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils;

import io.appulse.utils.BytesDelegateGets;
import io.appulse.utils.BytesDelegatePuts;
import io.appulse.utils.BytesDelegatePutsAs;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.stream.IntStream;

public final class Bytes {
    private final BytesDelegatePuts puts = new BytesDelegatePuts(this);
    private final BytesDelegatePutsAs putsAs = new BytesDelegatePutsAs(this);
    private final BytesDelegateGets gets = new BytesDelegateGets(this);
    private ByteBuffer buffer;

    public static Bytes wrap(byte[] bytes) {
        Bytes result = Bytes.allocate(bytes.length);
        return result.put(bytes);
    }

    public static Bytes wrap(ByteBuffer buffer) {
        ByteBuffer clone = ByteBuffer.wrap(buffer.array());
        return new Bytes(clone);
    }

    public static Bytes wrap(ByteBuf buf) {
        ByteBuffer buffer;
        if (buf.isDirect()) {
            buffer = buf.nioBuffer();
        } else {
            byte[] bytes = new byte[buf.readableBytes()];
            buf.getBytes(buf.readerIndex(), bytes);
            buffer = ByteBuffer.wrap(bytes);
        }
        return new Bytes(buffer);
    }

    public static Bytes allocate() {
        return Bytes.allocate(32);
    }

    public static Bytes allocate(int capacity) {
        ByteBuffer buffer = ByteBuffer.allocate(capacity);
        return new Bytes(buffer);
    }

    private Bytes(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public Bytes put(byte value) {
        this.checkCapacity(1);
        this.buffer.put(value);
        return this;
    }

    public Bytes put(int index, byte value) {
        this.buffer.put(index, value);
        return this;
    }

    public Bytes put(byte[] bytes) {
        this.checkCapacity(bytes.length);
        this.buffer.put(bytes);
        return this;
    }

    public Bytes put(int index, byte[] bytes) {
        this.checkCapacity(index, bytes.length);
        IntStream.range(index, index + bytes.length).forEach(it -> this.buffer.put(it, bytes[it - index]));
        return this;
    }

    public byte getByte() {
        return this.buffer.get();
    }

    public byte getByte(int index) {
        return this.buffer.get(index);
    }

    public byte[] getBytes() {
        return this.getBytes(0, this.buffer.remaining());
    }

    public byte[] getBytes(int length) {
        return this.getBytes(0, length);
    }

    public byte[] getBytes(int offset, int length) {
        byte[] result = new byte[length];
        this.buffer.get(result, offset, length);
        return result;
    }

    public byte[] array() {
        return Arrays.copyOfRange(this.buffer.array(), 0, this.buffer.position());
    }

    public int size() {
        return this.buffer.position();
    }

    public int position() {
        return this.buffer.position();
    }

    public Bytes position(int position) {
        this.buffer.position(position);
        return this;
    }

    public void clear() {
        this.buffer.clear();
    }

    public void flip() {
        this.buffer.flip();
    }

    private void checkCapacity(int size) {
        if (this.buffer.remaining() >= size) {
            return;
        }
        int newCapacity = this.buffer.limit() * 2;
        while (newCapacity - this.buffer.position() < size) {
            newCapacity *= 2;
        }
        this.buffer.flip();
        this.buffer = ByteBuffer.allocate(newCapacity).put(this.buffer);
    }

    private void checkCapacity(int from, int size) {
        int difference = size - (this.buffer.position() - from);
        if (difference > 0) {
            this.checkCapacity(difference);
        }
    }

    ByteBuffer getBuffer() {
        return this.buffer;
    }

    public Bytes put(short value) {
        return this.puts.put(value);
    }

    public Bytes put(int index, short value) {
        return this.puts.put(index, value);
    }

    public Bytes put(int value) {
        return this.puts.put(value);
    }

    public Bytes put(int index, int value) {
        return this.puts.put(index, value);
    }

    public Bytes put(long value) {
        return this.puts.put(value);
    }

    public Bytes put(int index, long value) {
        return this.puts.put(index, value);
    }

    public Bytes put(float value) {
        return this.puts.put(value);
    }

    public Bytes put(int index, float value) {
        return this.puts.put(index, value);
    }

    public Bytes put(double value) {
        return this.puts.put(value);
    }

    public Bytes put(int index, double value) {
        return this.puts.put(index, value);
    }

    public Bytes put(char value) {
        return this.puts.put(value);
    }

    public Bytes put(int index, char value) {
        return this.puts.put(index, value);
    }

    public Bytes put(String value) {
        return this.puts.put(value);
    }

    public Bytes put(String value, Charset charset) {
        return this.puts.put(value, charset);
    }

    public Bytes put(int index, String value) {
        return this.puts.put(index, value);
    }

    public Bytes put(int index, String value, Charset charset) {
        return this.puts.put(index, value, charset);
    }

    public Bytes putAsByte(byte value) {
        return this.putsAs.putAsByte(value);
    }

    public Bytes putAsByte(short value) {
        return this.putsAs.putAsByte(value);
    }

    public Bytes putAsByte(int value) {
        return this.putsAs.putAsByte(value);
    }

    public Bytes putAsByte(long value) {
        return this.putsAs.putAsByte(value);
    }

    public Bytes putAsShort(byte value) {
        return this.putsAs.putAsShort(value);
    }

    public Bytes putAsShort(short value) {
        return this.putsAs.putAsShort(value);
    }

    public Bytes putAsShort(int value) {
        return this.putsAs.putAsShort(value);
    }

    public Bytes putAsShort(long value) {
        return this.putsAs.putAsShort(value);
    }

    public Bytes putAsInt(byte value) {
        return this.putsAs.putAsInt(value);
    }

    public Bytes putAsInt(short value) {
        return this.putsAs.putAsInt(value);
    }

    public Bytes putAsInt(int value) {
        return this.putsAs.putAsInt(value);
    }

    public Bytes putAsInt(long value) {
        return this.putsAs.putAsInt(value);
    }

    public Bytes putAsLong(byte value) {
        return this.putsAs.putAsLong(value);
    }

    public Bytes putAsLong(short value) {
        return this.putsAs.putAsLong(value);
    }

    public Bytes putAsLong(int value) {
        return this.putsAs.putAsLong(value);
    }

    public Bytes putAsLong(long value) {
        return this.putsAs.putAsLong(value);
    }

    public Bytes putAligned(byte[] value, int length) {
        return this.putsAs.putAligned(value, length);
    }

    public char getChar() {
        return this.gets.getChar();
    }

    public char getChar(int index) {
        return this.gets.getChar(index);
    }

    public short getShort() {
        return this.gets.getShort();
    }

    public int getUnsignedShort() {
        return this.gets.getUnsignedShort();
    }

    public short getShort(int index) {
        return this.gets.getShort(index);
    }

    public int getInt() {
        return this.gets.getInt();
    }

    public int getInt(int index) {
        return this.gets.getInt(index);
    }

    public long getLong() {
        return this.gets.getLong();
    }

    public long getLong(int index) {
        return this.gets.getLong(index);
    }

    public float getFloat() {
        return this.gets.getFloat();
    }

    public float getFloat(int index) {
        return this.gets.getFloat(index);
    }

    public double getDouble() {
        return this.gets.getDouble();
    }

    public double getDouble(int index) {
        return this.gets.getDouble(index);
    }
}

