/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils;

import io.appulse.utils.Bytes;
import io.appulse.utils.BytesUtil;

final class BytesDelegatePutsAs {
    private final Bytes bytes;

    public Bytes putAsByte(byte value) {
        return this.bytes.put(value);
    }

    public Bytes putAsByte(short value) {
        return this.bytes.put((byte)value);
    }

    public Bytes putAsByte(int value) {
        return this.bytes.put((byte)value);
    }

    public Bytes putAsByte(long value) {
        return this.bytes.put((byte)value);
    }

    public Bytes putAsShort(byte value) {
        byte[] valueBytes = BytesUtil.asBytes(value);
        return this.putAligned(valueBytes, 2);
    }

    public Bytes putAsShort(short value) {
        return this.bytes.put(value);
    }

    public Bytes putAsShort(int value) {
        byte[] valueBytes = BytesUtil.asBytes(value);
        return this.putAligned(valueBytes, 2);
    }

    public Bytes putAsShort(long value) {
        byte[] valueBytes = BytesUtil.asBytes(value);
        return this.putAligned(valueBytes, 2);
    }

    public Bytes putAsInt(byte value) {
        byte[] valueBytes = BytesUtil.asBytes(value);
        return this.putAligned(valueBytes, 4);
    }

    public Bytes putAsInt(short value) {
        byte[] valueBytes = BytesUtil.asBytes(value);
        return this.putAligned(valueBytes, 4);
    }

    public Bytes putAsInt(int value) {
        return this.bytes.put(value);
    }

    public Bytes putAsInt(long value) {
        byte[] valueBytes = BytesUtil.asBytes(value);
        return this.putAligned(valueBytes, 4);
    }

    public Bytes putAsLong(byte value) {
        byte[] valueBytes = BytesUtil.asBytes(value);
        return this.putAligned(valueBytes, 8);
    }

    public Bytes putAsLong(short value) {
        byte[] valueBytes = BytesUtil.asBytes(value);
        return this.putAligned(valueBytes, 8);
    }

    public Bytes putAsLong(int value) {
        byte[] valueBytes = BytesUtil.asBytes(value);
        return this.putAligned(valueBytes, 8);
    }

    public Bytes putAsLong(long value) {
        return this.bytes.put(value);
    }

    public Bytes putAligned(byte[] value, int length) {
        return this.bytes.put(BytesUtil.align(value, length));
    }

    public BytesDelegatePutsAs(Bytes bytes) {
        this.bytes = bytes;
    }
}

