/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils;

import java.nio.ByteBuffer;
import java.util.stream.Stream;
import lombok.NonNull;

public final class BytesUtil {
    public static byte[] asBytes(char value) {
        return ByteBuffer.allocate(2).putChar(value).array();
    }

    public static byte[] asBytes(byte value) {
        return new byte[]{value};
    }

    public static byte[] asBytes(short value) {
        return ByteBuffer.allocate(2).putShort(value).array();
    }

    public static byte[] asBytes(int value) {
        return ByteBuffer.allocate(4).putInt(value).array();
    }

    public static byte[] asBytes(long value) {
        return ByteBuffer.allocate(8).putLong(value).array();
    }

    public static byte[] asBytes(float value) {
        return ByteBuffer.allocate(4).putFloat(value).array();
    }

    public static byte[] asBytes(double value) {
        return ByteBuffer.allocate(8).putDouble(value).array();
    }

    public static int asInteger(@NonNull ByteBuffer buffer, int length) {
        if (buffer == null) {
            throw new NullPointerException("buffer");
        }
        byte[] bytes = new byte[length];
        buffer.get(bytes, 0, length);
        return BytesUtil.asInteger(bytes);
    }

    public static int asInteger(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        byte[] aligned = BytesUtil.align(bytes, 4);
        return ByteBuffer.wrap(aligned).getInt();
    }

    public static byte[] concatenate(byte[] ... arrays) {
        if (arrays == null) {
            throw new NullPointerException("arrays");
        }
        int size = Stream.of(arrays).mapToInt(it -> ((byte[])it).length).sum();
        ByteBuffer buffer = ByteBuffer.allocate(size);
        Stream.of(arrays).forEach(buffer::put);
        return buffer.array();
    }

    public static byte[] align(@NonNull byte[] bytes, int length) {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        if (length <= 0) {
            return bytes;
        }
        byte[] result = new byte[length];
        int srcPos = 0;
        int destPos = 0;
        if (bytes.length > length) {
            srcPos = bytes.length - length;
        } else if (bytes.length < length) {
            destPos = length - bytes.length;
        }
        System.arraycopy(bytes, srcPos, result, destPos, Math.min(bytes.length, length));
        return result;
    }

    private BytesUtil() {
    }
}

