/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils;

import io.appulse.utils.Bytes;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.net.Socket;
import lombok.NonNull;

public final class StreamReader {
    public static byte[] read(@NonNull InputStream stream) {
        int length;
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(32);
        byte[] buffer = new byte[32];
        while ((length = stream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, length);
        }
        return outputStream.toByteArray();
    }

    public static byte[] read(@NonNull Socket socket) {
        if (socket == null) {
            throw new NullPointerException("socket");
        }
        return StreamReader.read(socket.getInputStream());
    }

    public static byte[] read(@NonNull InputStream stream, int length) {
        int count;
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException();
        }
        byte[] result = new byte[length];
        for (int readed = 0; readed < length; readed += count) {
            count = stream.read(result, readed, length - readed);
            if (count >= -1) continue;
            throw new EOFException();
        }
        return result;
    }

    public static byte[] read(@NonNull Socket socket, int length) {
        if (socket == null) {
            throw new NullPointerException("socket");
        }
        return StreamReader.read(socket.getInputStream(), length);
    }

    public static Bytes readBytes(@NonNull InputStream stream) {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        byte[] result = StreamReader.read(stream);
        return Bytes.wrap(result);
    }

    public static Bytes readBytes(@NonNull Socket socket) {
        if (socket == null) {
            throw new NullPointerException("socket");
        }
        return StreamReader.readBytes(socket.getInputStream());
    }

    public static Bytes readBytes(@NonNull InputStream stream, int length) {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        byte[] result = StreamReader.read(stream, length);
        return Bytes.wrap(result);
    }

    public static Bytes readBytes(@NonNull Socket socket, int fixedLength) {
        if (socket == null) {
            throw new NullPointerException("socket");
        }
        return StreamReader.readBytes(socket.getInputStream(), fixedLength);
    }

    private StreamReader() {
    }
}

