/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appulse.utils.Bytes;
import io.appulse.utils.BytesAbstract;
import io.appulse.utils.SizeUnit;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.NonNull;

public class BytesPool {
    private static final int DEFAULT_INITIAL_BUFFERS_COUNT = 2;
    private static final int DEFAULT_MAXIMUM_BUFFERS_COUNT = Integer.MAX_VALUE;
    private static final int DEFAULT_INITIAL_BUFFER_SIZE = (int)SizeUnit.KILOBYTES.toBytes(8L);
    private final int maximumBuffersCount;
    private final int initialBufferSizeBytes;
    private final Function<Integer, Bytes> bufferCreateFunction;
    private final BlockingQueue<Bytes> buffers;
    private final LongAdder acquiredBuffersCount;
    private final LongAdder totalElements;
    private final Lock createNewLock;

    BytesPool(Integer initialBuffersCount, Integer maximumBuffersCount, Integer initialBufferSizeBytes, Function<Integer, Bytes> bufferCreateFunction) {
        int initialBuffers = Optional.ofNullable(initialBuffersCount).filter(it -> it >= 0).filter(it -> it <= maximumBuffersCount).orElse(2);
        this.maximumBuffersCount = Optional.ofNullable(maximumBuffersCount).filter(it -> it >= 0).filter(it -> it >= initialBuffers).orElse(Integer.MAX_VALUE);
        this.initialBufferSizeBytes = Optional.ofNullable(initialBufferSizeBytes).filter(it -> it > 0).orElse(DEFAULT_INITIAL_BUFFER_SIZE);
        this.bufferCreateFunction = bufferCreateFunction;
        this.totalElements = new LongAdder();
        this.acquiredBuffersCount = new LongAdder();
        this.createNewLock = new ReentrantLock(true);
        this.buffers = IntStream.range(0, initialBuffers).mapToObj(it -> (Bytes)bufferCreateFunction.apply(initialBufferSizeBytes)).peek(it -> this.totalElements.increment()).collect(Collectors.toCollection(LinkedBlockingQueue::new));
    }

    public PooledBytes acquire() {
        Bytes buffer = this.getOrCreateBuffer();
        this.acquiredBuffersCount.increment();
        buffer.reset();
        return new PooledBytes(buffer);
    }

    public PooledBytes acquire(int minSize) {
        PooledBytes result = this.acquire();
        if (result.capacity() < minSize) {
            result.capacity(minSize);
        }
        return result;
    }

    public void release(@NonNull PooledBytes buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        if (buffer.parent != this) {
            throw new IllegalArgumentException("The buffer not from this pool");
        }
        Bytes detached = buffer.detach();
        if (!this.buffers.offer(detached)) {
            throw new IllegalStateException("Unexpected behaviour");
        }
        this.acquiredBuffersCount.decrement();
    }

    public int getAcquiredCount() {
        return this.acquiredBuffersCount.intValue();
    }

    public int getFreeCount() {
        return this.maximumBuffersCount - this.acquiredBuffersCount.intValue();
    }

    public int getTotalCount() {
        return this.totalElements.intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bytes getOrCreateBuffer() throws InterruptedException {
        Bytes buffer = (Bytes)this.buffers.poll();
        if (buffer != null) {
            return buffer;
        }
        this.createNewLock.lock();
        try {
            if (this.totalElements.sum() >= (long)this.maximumBuffersCount) {
                Bytes bytes = this.buffers.take();
                return bytes;
            }
            Bytes newBuffer = this.bufferCreateFunction.apply(this.initialBufferSizeBytes);
            this.totalElements.increment();
            Bytes bytes = newBuffer;
            return bytes;
        }
        finally {
            this.createNewLock.unlock();
        }
    }

    @SuppressFBWarnings(justification="generated code")
    public static BytesPoolBuilder builder() {
        return new BytesPoolBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    public static class BytesPoolBuilder {
        @SuppressFBWarnings(justification="generated code")
        private Integer initialBuffersCount;
        @SuppressFBWarnings(justification="generated code")
        private Integer maximumBuffersCount;
        @SuppressFBWarnings(justification="generated code")
        private Integer initialBufferSizeBytes;
        @SuppressFBWarnings(justification="generated code")
        private Function<Integer, Bytes> bufferCreateFunction;

        @SuppressFBWarnings(justification="generated code")
        BytesPoolBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public BytesPoolBuilder initialBuffersCount(Integer initialBuffersCount) {
            this.initialBuffersCount = initialBuffersCount;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public BytesPoolBuilder maximumBuffersCount(Integer maximumBuffersCount) {
            this.maximumBuffersCount = maximumBuffersCount;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public BytesPoolBuilder initialBufferSizeBytes(Integer initialBufferSizeBytes) {
            this.initialBufferSizeBytes = initialBufferSizeBytes;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public BytesPoolBuilder bufferCreateFunction(Function<Integer, Bytes> bufferCreateFunction) {
            this.bufferCreateFunction = bufferCreateFunction;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public BytesPool build() {
            return new BytesPool(this.initialBuffersCount, this.maximumBuffersCount, this.initialBufferSizeBytes, this.bufferCreateFunction);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "BytesPool.BytesPoolBuilder(initialBuffersCount=" + this.initialBuffersCount + ", maximumBuffersCount=" + this.maximumBuffersCount + ", initialBufferSizeBytes=" + this.initialBufferSizeBytes + ", bufferCreateFunction=" + this.bufferCreateFunction + ")";
        }
    }

    public class PooledBytes
    extends BytesAbstract {
        private Bytes delegate;
        private BytesPool parent;

        PooledBytes(Bytes delegate) {
            this.parent = BytesPool.this;
            this.delegate = delegate;
        }

        public void release() {
            BytesPool.this.release(this);
        }

        @Override
        public boolean isAutoResizable() {
            this.validate();
            return this.delegate.isAutoResizable();
        }

        @Override
        public Bytes writeNB(byte[] bytes, int offset, int length) {
            this.validate();
            return this.delegate.writeNB(bytes, offset, length);
        }

        @Override
        public Bytes write1B(byte value) {
            this.validate();
            return this.delegate.write1B(value);
        }

        @Override
        public Bytes write2B(short value) {
            this.validate();
            return this.delegate.write2B(value);
        }

        @Override
        public Bytes write4B(int value) {
            this.validate();
            return this.delegate.write4B(value);
        }

        @Override
        public Bytes write8B(long value) {
            this.validate();
            return this.delegate.write8B(value);
        }

        @Override
        public Bytes setNB(int index, byte[] bytes, int offset, int length) {
            this.validate();
            return this.delegate.setNB(index, bytes, offset, length);
        }

        @Override
        public Bytes set1B(int index, byte value) {
            this.validate();
            return this.delegate.set1B(index, value);
        }

        @Override
        public Bytes set2B(int index, short value) {
            this.validate();
            return this.delegate.set2B(index, value);
        }

        @Override
        public Bytes set4B(int index, int value) {
            this.validate();
            return this.delegate.set4B(index, value);
        }

        @Override
        public Bytes set8B(int index, long value) {
            this.validate();
            return this.delegate.set8B(index, value);
        }

        @Override
        public byte readByte() {
            this.validate();
            return this.delegate.readByte();
        }

        @Override
        public short readShort() {
            this.validate();
            return this.delegate.readShort();
        }

        @Override
        public int readInt() {
            this.validate();
            return this.delegate.readInt();
        }

        @Override
        public long readLong() {
            this.validate();
            return this.delegate.readLong();
        }

        @Override
        public float readFloat() {
            this.validate();
            return this.delegate.readFloat();
        }

        @Override
        public double readDouble() {
            this.validate();
            return this.delegate.readDouble();
        }

        @Override
        public char readChar() {
            this.validate();
            return this.delegate.readChar();
        }

        @Override
        public Bytes readBytes(byte[] destination, int offset, int length) {
            this.validate();
            return this.delegate.readBytes(destination, offset, length);
        }

        @Override
        public byte getByte(int index) {
            this.validate();
            return this.delegate.getByte(index);
        }

        @Override
        public short getShort(int index) {
            this.validate();
            return this.delegate.getShort(index);
        }

        @Override
        public int getInt(int index) {
            this.validate();
            return this.delegate.getInt(index);
        }

        @Override
        public long getLong(int index) {
            this.validate();
            return this.delegate.getLong(index);
        }

        @Override
        public float getFloat(int index) {
            this.validate();
            return this.delegate.getFloat(index);
        }

        @Override
        public double getDouble(int index) {
            this.validate();
            return this.delegate.getDouble(index);
        }

        @Override
        public char getChar(int index) {
            this.validate();
            return this.delegate.getChar(index);
        }

        @Override
        public byte[] getBytes(int index, int length) {
            this.validate();
            return this.delegate.getBytes(index, length);
        }

        @Override
        public String getString(int index, int length, Charset charset) {
            this.validate();
            return this.delegate.getString(index, length, charset);
        }

        @Override
        public int capacity() {
            this.validate();
            return this.delegate.capacity();
        }

        @Override
        public void capacity(int bytes) {
            this.validate();
            this.delegate.capacity(bytes);
        }

        @Override
        public int writerIndex() {
            this.validate();
            return this.delegate.writerIndex();
        }

        @Override
        public Bytes writerIndex(int newIndex) {
            this.validate();
            return this.delegate.writerIndex(newIndex);
        }

        @Override
        public int readerIndex() {
            this.validate();
            return this.delegate.readerIndex();
        }

        @Override
        public Bytes readerIndex(int newIndex) {
            this.validate();
            return this.delegate.readerIndex(newIndex);
        }

        @Override
        public byte[] array() {
            this.validate();
            return this.delegate.array();
        }

        private void validate() {
            if (this.delegate != null) {
                return;
            }
            String msg = String.format(Locale.ENGLISH, "Pooled bytes buffer already released", new Object[0]);
            throw new IllegalStateException(msg);
        }

        private Bytes detach() {
            Bytes result = this.delegate;
            this.delegate = null;
            return result;
        }
    }
}

