/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils;

import io.appulse.utils.Bytes;
import java.io.File;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Locale;
import lombok.NonNull;

public final class WriteBytesUtils {
    public static int write(OutputStream outputStream, @NonNull byte[] buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        return WriteBytesUtils.write(outputStream, buffer, 0, buffer.length);
    }

    public static int write(OutputStream outputStream, byte[] buffer, int length) {
        return WriteBytesUtils.write(outputStream, buffer, 0, length);
    }

    public static int write(@NonNull OutputStream outputStream, @NonNull byte[] bytes, int offset, int length) {
        if (outputStream == null) {
            throw new NullPointerException("outputStream is marked non-null but is null");
        }
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        if (offset < 0 || offset >= bytes.length) {
            String msg = String.format(Locale.ENGLISH, "Invalid offset %d. The offset must be equal or greater than 0 and less than byte array length (%d)", offset, bytes.length);
            throw new IndexOutOfBoundsException(msg);
        }
        if (length < 0) {
            String msg = String.format(Locale.ENGLISH, "Invalid length %d. The length must be greater or equal 0", length);
            throw new IndexOutOfBoundsException(msg);
        }
        int position = offset;
        int remaining = Math.min(bytes.length - offset, length);
        while (remaining > 0) {
            int bufferSize = Math.min(remaining, 8192);
            outputStream.write(bytes, position, bufferSize);
            remaining -= bufferSize;
            position += bufferSize;
        }
        return position - offset;
    }

    public static int write(OutputStream outputStream, @NonNull ByteBuffer buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        return WriteBytesUtils.write(outputStream, buffer, buffer.remaining());
    }

    public static int write(@NonNull OutputStream outputStream, @NonNull ByteBuffer buffer, int length) {
        if (outputStream == null) {
            throw new NullPointerException("outputStream is marked non-null but is null");
        }
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        byte[] bytes = buffer.array();
        int written = WriteBytesUtils.write(outputStream, bytes, buffer.position(), length);
        buffer.position(buffer.position() + written);
        return written;
    }

    public static int write(OutputStream outputStream, @NonNull Bytes buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        return WriteBytesUtils.write(outputStream, buffer, buffer.readableBytes());
    }

    public static int write(@NonNull OutputStream outputStream, @NonNull Bytes buffer, int length) {
        if (outputStream == null) {
            throw new NullPointerException("outputStream is marked non-null but is null");
        }
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        byte[] bytes = buffer.array();
        int written = WriteBytesUtils.write(outputStream, bytes, buffer.readerIndex(), length);
        buffer.readerIndex(buffer.readerIndex() + written);
        return written;
    }

    public static int write(WritableByteChannel channel, @NonNull byte[] buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        return WriteBytesUtils.write(channel, buffer, 0, buffer.length);
    }

    public static int write(WritableByteChannel channel, byte[] buffer, int length) {
        return WriteBytesUtils.write(channel, buffer, 0, length);
    }

    public static int write(@NonNull WritableByteChannel channel, @NonNull byte[] bytes, int offset, int length) {
        int written;
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        if (offset < 0 || offset >= bytes.length) {
            String msg = String.format(Locale.ENGLISH, "Invalid offset %d. The offset must be equal or greater than 0 and less than byte array length (%d)", offset, bytes.length);
            throw new IndexOutOfBoundsException(msg);
        }
        if (length < 0) {
            String msg = String.format(Locale.ENGLISH, "Invalid length %d. The length must be greater or equal 0", length);
            throw new IndexOutOfBoundsException(msg);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        byteBuffer.position(offset);
        int limit = Math.min(offset + length, bytes.length);
        byteBuffer.limit(limit);
        int totalWritten = 0;
        while (byteBuffer.hasRemaining() && (written = channel.write(byteBuffer)) >= 0) {
            totalWritten += written;
        }
        return totalWritten;
    }

    public static int write(WritableByteChannel channel, @NonNull ByteBuffer buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        return WriteBytesUtils.write(channel, buffer, buffer.remaining());
    }

    public static int write(@NonNull WritableByteChannel channel, @NonNull ByteBuffer buffer, int length) {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        byte[] bytes = buffer.array();
        int written = WriteBytesUtils.write(channel, bytes, buffer.position(), length);
        buffer.position(buffer.position() + written);
        return written;
    }

    public static int write(WritableByteChannel channel, @NonNull Bytes buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        return WriteBytesUtils.write(channel, buffer, buffer.readableBytes());
    }

    public static int write(@NonNull WritableByteChannel channel, @NonNull Bytes buffer, int length) {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        byte[] bytes = buffer.array();
        int written = WriteBytesUtils.write(channel, bytes, buffer.readerIndex(), length);
        buffer.readerIndex(buffer.readerIndex() + written);
        return written;
    }

    public static int write(File file, @NonNull byte[] buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        return WriteBytesUtils.write(file, buffer, 0, buffer.length);
    }

    public static int write(File file, byte[] buffer, int length) {
        return WriteBytesUtils.write(file, buffer, 0, length);
    }

    public static int write(@NonNull File file, byte[] buffer, int offset, int length) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return WriteBytesUtils.write(file.toPath(), buffer, offset, length);
    }

    public static int write(File file, @NonNull ByteBuffer buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        return WriteBytesUtils.write(file, buffer, buffer.remaining());
    }

    public static int write(@NonNull File file, ByteBuffer buffer, int length) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return WriteBytesUtils.write(file.toPath(), buffer, length);
    }

    public static int write(File file, @NonNull Bytes buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        return WriteBytesUtils.write(file, buffer, buffer.readableBytes());
    }

    public static int write(@NonNull File file, Bytes buffer, int length) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return WriteBytesUtils.write(file.toPath(), buffer, length);
    }

    public static int write(Path path, @NonNull byte[] buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        return WriteBytesUtils.write(path, buffer, 0, buffer.length);
    }

    public static int write(Path path, byte[] buffer, int length) {
        return WriteBytesUtils.write(path, buffer, 0, length);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int write(@NonNull Path path, byte[] buffer, int offset, int length) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        try (SeekableByteChannel channel = Files.newByteChannel(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            int n = WriteBytesUtils.write(channel, buffer, offset, length);
            return n;
        }
    }

    public static int write(Path path, @NonNull ByteBuffer buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        return WriteBytesUtils.write(path, buffer, buffer.remaining());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int write(@NonNull Path path, ByteBuffer buffer, int length) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        try (SeekableByteChannel channel = Files.newByteChannel(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            int n = WriteBytesUtils.write((WritableByteChannel)channel, buffer, length);
            return n;
        }
    }

    public static int write(Path path, @NonNull Bytes buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        return WriteBytesUtils.write(path, buffer, buffer.readableBytes());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int write(@NonNull Path path, Bytes buffer, int length) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        try (SeekableByteChannel channel = Files.newByteChannel(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            int n = WriteBytesUtils.write((WritableByteChannel)channel, buffer, length);
            return n;
        }
    }

    private WriteBytesUtils() {
        throw new UnsupportedOperationException();
    }
}

