/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils.exception;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Locale;
import lombok.NonNull;

public final class CantReadFromArrayException
extends IllegalArgumentException {
    private static final long serialVersionUID = 8116975573032550733L;
    @NonNull
    private final byte[] array;
    private final int from;
    private final int length;

    @Override
    public String getMessage() {
        return String.format(Locale.ENGLISH, "Can't read from an array between %d and %d indexes, because actual array's length is %d", this.from, this.from + this.length - 1, this.array.length);
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    public byte[] getArray() {
        return this.array;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getFrom() {
        return this.from;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getLength() {
        return this.length;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "CantReadFromArrayException(array=" + Arrays.toString(this.getArray()) + ", from=" + this.getFrom() + ", length=" + this.getLength() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    public CantReadFromArrayException(@NonNull byte[] array, int from, int length) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        this.array = array;
        this.from = from;
        this.length = length;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CantReadFromArrayException)) {
            return false;
        }
        CantReadFromArrayException other = (CantReadFromArrayException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!Arrays.equals(this.getArray(), other.getArray())) {
            return false;
        }
        if (this.getFrom() != other.getFrom()) {
            return false;
        }
        return this.getLength() == other.getLength();
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof CantReadFromArrayException;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.hashCode(this.getArray());
        result = result * 59 + this.getFrom();
        result = result * 59 + this.getLength();
        return result;
    }
}

