/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils;

import io.appulse.utils.Bytes;
import java.io.IOException;
import java.io.OutputStream;

public class BytesOutputStream
extends OutputStream {
    private final Bytes buffer;

    public BytesOutputStream() {
        this(32);
    }

    public BytesOutputStream(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative initial size: " + size);
        }
        this.buffer = Bytes.resizableArray(size);
    }

    public BytesOutputStream(Bytes bytes) {
        this.buffer = bytes;
    }

    @Override
    public synchronized void write(int value) throws IOException {
        this.buffer.write1B(value);
    }

    @Override
    public synchronized void write(byte[] bytes, int offset, int length) {
        this.buffer.writeNB(bytes, offset, length);
    }

    public synchronized void reset() {
        this.buffer.reset();
    }

    public synchronized int size() {
        return this.buffer.writerIndex();
    }

    public synchronized byte[] toByteArray() {
        return this.buffer.arrayCopy();
    }

    public byte[] array() {
        return this.buffer.array();
    }

    @Override
    public void close() {
    }
}

