/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appulse.utils.Bytes;
import io.appulse.utils.BytesFixedArray;
import java.nio.charset.Charset;
import lombok.NonNull;

class BytesSlice
extends BytesFixedArray {
    private final int from;
    private final int to;

    BytesSlice(Bytes delegate, @NonNull Integer from, @NonNull Integer to) {
        if (from == null) {
            throw new NullPointerException("from is marked non-null but is null");
        }
        if (to == null) {
            throw new NullPointerException("to is marked non-null but is null");
        }
        this.buffer = delegate.array();
        this.from = from;
        this.to = to;
        this.writerIndex = delegate.writerIndex() < from ? from : (delegate.writerIndex() > to ? to.intValue() : delegate.writerIndex());
        this.readerIndex = from;
    }

    @Override
    public Bytes writeNB(@NonNull byte[] bytes, int offset, int length) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        super.setNB(this.writerIndex, bytes, offset, length);
        this.writerIndex += length;
        return this;
    }

    @Override
    public Bytes write1B(byte value) {
        super.set1B(this.writerIndex, value);
        ++this.writerIndex;
        return this;
    }

    @Override
    public Bytes write2B(short value) {
        super.set2B(this.writerIndex, value);
        this.writerIndex += 2;
        return this;
    }

    @Override
    public Bytes write4B(int value) {
        super.set4B(this.writerIndex, value);
        this.writerIndex += 4;
        return this;
    }

    @Override
    public Bytes write8B(long value) {
        super.set8B(this.writerIndex, value);
        this.writerIndex += 8;
        return this;
    }

    @Override
    public Bytes setNB(int index, byte[] bytes, int offset, int length) {
        int newIndex = this.from + index;
        return super.setNB(newIndex, bytes, offset, length);
    }

    @Override
    public Bytes set1B(int index, byte value) {
        int newIndex = this.from + index;
        return super.set1B(newIndex, value);
    }

    @Override
    public Bytes set2B(int index, short value) {
        int newIndex = this.from + index;
        return super.set2B(newIndex, value);
    }

    @Override
    public Bytes set4B(int index, int value) {
        int newIndex = this.from + index;
        return super.set4B(newIndex, value);
    }

    @Override
    public Bytes set8B(int index, long value) {
        int newIndex = this.from + index;
        return super.set8B(newIndex, value);
    }

    @Override
    public byte readByte() {
        byte result = super.getByte(this.readerIndex);
        ++this.readerIndex;
        return result;
    }

    @Override
    public short readShort() {
        short result = super.getShort(this.readerIndex);
        this.readerIndex += 2;
        return result;
    }

    @Override
    public int readInt() {
        int result = super.getInt(this.readerIndex);
        this.readerIndex += 4;
        return result;
    }

    @Override
    public long readLong() {
        long result = super.getLong(this.readerIndex);
        this.readerIndex += 8;
        return result;
    }

    @Override
    public float readFloat() {
        float result = super.getFloat(this.readerIndex);
        this.readerIndex += 4;
        return result;
    }

    @Override
    public double readDouble() {
        double result = super.getDouble(this.readerIndex);
        this.readerIndex += 8;
        return result;
    }

    @Override
    public char readChar() {
        char result = super.getChar(this.readerIndex);
        this.readerIndex += 2;
        return result;
    }

    @Override
    public Bytes readBytes(@NonNull byte[] destination, int offset, int length) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        this.checkReaderBounds(this.readerIndex, length);
        System.arraycopy(this.buffer, this.readerIndex, destination, offset, length);
        this.readerIndex += length;
        return this;
    }

    @Override
    public byte getByte(int index) {
        int newIndex = this.from + index;
        return super.getByte(newIndex);
    }

    @Override
    public short getShort(int index) {
        int newIndex = this.from + index;
        return super.getShort(newIndex);
    }

    @Override
    public int getInt(int index) {
        int newIndex = this.from + index;
        return super.getInt(newIndex);
    }

    @Override
    public long getLong(int index) {
        int newIndex = this.from + index;
        return super.getLong(newIndex);
    }

    @Override
    public float getFloat(int index) {
        int newIndex = this.from + index;
        return super.getFloat(newIndex);
    }

    @Override
    public double getDouble(int index) {
        int newIndex = this.from + index;
        return super.getDouble(newIndex);
    }

    @Override
    public char getChar(int index) {
        int newIndex = this.from + index;
        return super.getChar(newIndex);
    }

    @Override
    public byte[] getBytes(int index, int length) {
        int newIndex = this.from + index;
        return super.getBytes(newIndex, length);
    }

    @Override
    public String getString(int index, int length, Charset charset) {
        int newIndex = this.from + index;
        return super.getString(newIndex, length, charset);
    }

    @Override
    public int capacity() {
        return this.to - this.from;
    }

    @Override
    public void capacity(int bytes) {
        String msg = "The operation doesn't support in BytesSlice wrapper";
        throw new UnsupportedOperationException("The operation doesn't support in BytesSlice wrapper");
    }

    @Override
    public int writerIndex() {
        return super.writerIndex() - this.from;
    }

    @Override
    public Bytes writerIndex(int newIndex) {
        int index;
        if (newIndex < this.readerIndex() || newIndex > this.capacity()) {
            String msg = String.format("Writer index error: newIndex(%d) < readerIndex(%d) || newIndex(%d) > capacity(%d)", newIndex, this.readerIndex(), newIndex, this.capacity());
            throw new IndexOutOfBoundsException(msg);
        }
        this.writerIndex = index = this.from + newIndex;
        return this;
    }

    @Override
    public int readerIndex() {
        return super.readerIndex() - this.from;
    }

    @Override
    protected void checkWriteBounds(int index, int length) {
        if (index < super.readerIndex() || index + length > super.capacity()) {
            String msg = String.format("Writer index error. index(%d) < readerIndex(%d) || index(%d)+length(%d) > capacity(%d)", index, super.readerIndex(), index, length, super.capacity());
            throw new IndexOutOfBoundsException(msg);
        }
    }

    @Override
    protected void checkReaderBounds(int index, int length) {
        if (index < 0 || index + length > super.writerIndex()) {
            String msg = String.format("Reader index error. index(%d) < 0 || index(%d)+length(%d) > writerIndex(%d)", index, index, length, super.writerIndex());
            throw new IndexOutOfBoundsException(msg);
        }
    }

    @Override
    public Bytes readerIndex(int newIndex) {
        int index;
        if (newIndex < 0 || newIndex > this.writerIndex()) {
            String msg = String.format("Reader index error: newIndex(%d) < 0 || newIndex(%d) > writerIndex(%d)", newIndex, newIndex, this.writerIndex());
            throw new IndexOutOfBoundsException(msg);
        }
        this.readerIndex = index = this.from + newIndex;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    public static BytesSliceBuilder builder() {
        return new BytesSliceBuilder();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BytesSlice)) {
            return false;
        }
        BytesSlice other = (BytesSlice)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.from != other.from) {
            return false;
        }
        return this.to == other.to;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof BytesSlice;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.from;
        result = result * 59 + this.to;
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public static class BytesSliceBuilder {
        @SuppressFBWarnings(justification="generated code")
        private Bytes delegate;
        @SuppressFBWarnings(justification="generated code")
        private Integer from;
        @SuppressFBWarnings(justification="generated code")
        private Integer to;

        @SuppressFBWarnings(justification="generated code")
        BytesSliceBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public BytesSliceBuilder delegate(Bytes delegate) {
            this.delegate = delegate;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public BytesSliceBuilder from(@NonNull Integer from) {
            if (from == null) {
                throw new NullPointerException("from is marked non-null but is null");
            }
            this.from = from;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public BytesSliceBuilder to(@NonNull Integer to) {
            if (to == null) {
                throw new NullPointerException("to is marked non-null but is null");
            }
            this.to = to;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public BytesSlice build() {
            return new BytesSlice(this.delegate, this.from, this.to);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "BytesSlice.BytesSliceBuilder(delegate=" + this.delegate + ", from=" + this.from + ", to=" + this.to + ")";
        }
    }
}

