/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils;

import io.appulse.utils.exception.SerializationException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import lombok.NonNull;

public final class SerializationUtils {
    public static void serialize(Serializable object, @NonNull OutputStream outputStream) {
        if (outputStream == null) {
            throw new NullPointerException("outputStream is marked non-null but is null");
        }
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);){
            objectOutputStream.writeObject(object);
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
    }

    public static byte[] serialize(Serializable obj) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        SerializationUtils.serialize(obj, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T deserialize(@NonNull InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked non-null but is null");
        }
        try (ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);){
            Object obj;
            Object object = obj = objectInputStream.readObject();
            return (T)object;
        }
        catch (IOException | ClassNotFoundException ex) {
            throw new SerializationException(ex);
        }
    }

    public static <T> T deserialize(@NonNull byte[] objectData) {
        if (objectData == null) {
            throw new NullPointerException("objectData is marked non-null but is null");
        }
        return SerializationUtils.deserialize(new ByteArrayInputStream(objectData));
    }

    private SerializationUtils() {
    }
}

