/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils;

import io.appulse.utils.BytesDelegateGets;
import io.appulse.utils.BytesDelegatePuts;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.stream.IntStream;
import lombok.NonNull;

public final class Bytes {
    private final BytesDelegatePuts puts = new BytesDelegatePuts(this);
    private final BytesDelegateGets gets = new BytesDelegateGets(this);
    private ByteBuffer buffer;
    private int limit;

    public static Bytes wrap(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        Bytes result = Bytes.allocate(bytes.length);
        result.put(bytes);
        result.flip();
        return result;
    }

    public static Bytes wrap(@NonNull ByteBuffer buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer");
        }
        return Bytes.wrap(buffer.array());
    }

    public static Bytes allocate() {
        return Bytes.allocate(32);
    }

    public static Bytes allocate(int capacity) {
        ByteBuffer buffer = ByteBuffer.allocate(capacity);
        return new Bytes(buffer);
    }

    private Bytes(ByteBuffer buffer) {
        this.buffer = buffer;
        this.limit = buffer.position();
    }

    public Bytes put(byte value) {
        this.checkCapacity(1);
        this.buffer.put(value);
        ++this.limit;
        return this;
    }

    public Bytes put(int index, byte value) {
        this.buffer.put(index, value);
        return this;
    }

    public Bytes put(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        this.checkCapacity(bytes.length);
        this.buffer.put(bytes);
        this.limit += bytes.length;
        return this;
    }

    public Bytes put(int index, @NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        this.checkCapacity(index, bytes.length);
        IntStream.range(index, index + bytes.length).forEach(it -> this.buffer.put(it, bytes[it - index]));
        return this;
    }

    public byte getByte() {
        return this.buffer.get();
    }

    public byte getByte(int index) {
        return this.buffer.get(index);
    }

    public byte[] getBytes() {
        return this.getBytes(0, this.buffer.remaining());
    }

    public byte[] getBytes(int length) {
        return this.getBytes(0, length);
    }

    public byte[] getBytes(int offset, int length) {
        byte[] result = new byte[length];
        this.buffer.get(result, offset, length);
        return result;
    }

    public byte[] array() {
        return Arrays.copyOfRange(this.buffer.array(), 0, this.limit);
    }

    public byte[] array(int offset) {
        if (offset < 0 || offset > this.limit) {
            throw new IndexOutOfBoundsException();
        }
        return Arrays.copyOfRange(this.buffer.array(), offset, this.limit);
    }

    public int limit() {
        return this.limit;
    }

    public int remaining() {
        return this.limit - this.buffer.position();
    }

    public int position() {
        return this.buffer.position();
    }

    public Bytes position(int position) {
        if (position > this.limit || position < 0) {
            throw new IllegalArgumentException();
        }
        this.buffer.position(position);
        return this;
    }

    public Bytes clear() {
        this.buffer.clear();
        this.limit = 0;
        return this;
    }

    public Bytes flip() {
        this.limit = this.buffer.position();
        this.buffer.flip();
        return this;
    }

    private void checkCapacity(int size) {
        if (this.buffer.remaining() >= size) {
            return;
        }
        int newCapacity = this.buffer.limit() * 2;
        while (newCapacity - this.buffer.position() < size) {
            newCapacity *= 2;
        }
        this.buffer.flip();
        this.buffer = ByteBuffer.allocate(newCapacity).put(this.buffer);
    }

    private void checkCapacity(int from, int size) {
        int difference = size - (this.buffer.position() - from);
        if (difference > 0) {
            this.checkCapacity(difference);
        }
    }

    ByteBuffer getBuffer() {
        return this.buffer;
    }

    public Bytes putNB(byte value, int length) {
        return this.puts.putNB(value, length);
    }

    public Bytes putNB(int index, byte value, int length) {
        return this.puts.putNB(index, value, length);
    }

    public Bytes putNB(short value, int length) {
        return this.puts.putNB(value, length);
    }

    public Bytes putNB(int index, short value, int length) {
        return this.puts.putNB(index, value, length);
    }

    public Bytes putNB(int value, int length) {
        return this.puts.putNB(value, length);
    }

    public Bytes putNB(int index, int value, int length) {
        return this.puts.putNB(index, value, length);
    }

    public Bytes putNB(long value, int length) {
        return this.puts.putNB(value, length);
    }

    public Bytes putNB(int index, long value, int length) {
        return this.puts.putNB(index, value, length);
    }

    public Bytes putNB(byte[] value, int length) {
        return this.puts.putNB(value, length);
    }

    public Bytes putNB(int index, byte[] value, int length) {
        return this.puts.putNB(index, value, length);
    }

    public Bytes put1B(byte value) {
        return this.puts.put1B(value);
    }

    public Bytes put1B(int index, byte value) {
        return this.puts.put1B(index, value);
    }

    public Bytes put1B(short value) {
        return this.puts.put1B(value);
    }

    public Bytes put1B(int index, short value) {
        return this.puts.put1B(index, value);
    }

    public Bytes put1B(int value) {
        return this.puts.put1B(value);
    }

    public Bytes put1B(int index, int value) {
        return this.puts.put1B(index, value);
    }

    public Bytes put1B(long value) {
        return this.puts.put1B(value);
    }

    public Bytes put1B(int index, long value) {
        return this.puts.put1B(index, value);
    }

    public Bytes put2B(byte value) {
        return this.puts.put2B(value);
    }

    public Bytes put2B(int index, byte value) {
        return this.puts.put2B(index, value);
    }

    public Bytes put2B(short value) {
        return this.puts.put2B(value);
    }

    public Bytes put2B(int index, short value) {
        return this.puts.put2B(index, value);
    }

    public Bytes put2B(int value) {
        return this.puts.put2B(value);
    }

    public Bytes put2B(int index, int value) {
        return this.puts.put2B(index, value);
    }

    public Bytes put2B(long value) {
        return this.puts.put2B(value);
    }

    public Bytes put2B(int index, long value) {
        return this.puts.put2B(index, value);
    }

    public Bytes put4B(byte value) {
        return this.puts.put4B(value);
    }

    public Bytes put4B(int index, byte value) {
        return this.puts.put4B(index, value);
    }

    public Bytes put4B(short value) {
        return this.puts.put4B(value);
    }

    public Bytes put4B(int index, short value) {
        return this.puts.put4B(index, value);
    }

    public Bytes put4B(int value) {
        return this.puts.put4B(value);
    }

    public Bytes put4B(int index, int value) {
        return this.puts.put4B(index, value);
    }

    public Bytes put4B(long value) {
        return this.puts.put4B(value);
    }

    public Bytes put4B(int index, long value) {
        return this.puts.put4B(index, value);
    }

    public Bytes put8B(byte value) {
        return this.puts.put8B(value);
    }

    public Bytes put8B(int index, byte value) {
        return this.puts.put8B(index, value);
    }

    public Bytes put8B(short value) {
        return this.puts.put8B(value);
    }

    public Bytes put8B(int index, short value) {
        return this.puts.put8B(index, value);
    }

    public Bytes put8B(int value) {
        return this.puts.put8B(value);
    }

    public Bytes put8B(int index, int value) {
        return this.puts.put8B(index, value);
    }

    public Bytes put8B(long value) {
        return this.puts.put8B(value);
    }

    public Bytes put8B(int index, long value) {
        return this.puts.put8B(index, value);
    }

    public Bytes put(short value) {
        return this.puts.put(value);
    }

    public Bytes put(int index, short value) {
        return this.puts.put(index, value);
    }

    public Bytes put(int value) {
        return this.puts.put(value);
    }

    public Bytes put(int index, int value) {
        return this.puts.put(index, value);
    }

    public Bytes put(long value) {
        return this.puts.put(value);
    }

    public Bytes put(int index, long value) {
        return this.puts.put(index, value);
    }

    public Bytes put(float value) {
        return this.puts.put(value);
    }

    public Bytes put(int index, float value) {
        return this.puts.put(index, value);
    }

    public Bytes put(double value) {
        return this.puts.put(value);
    }

    public Bytes put(int index, double value) {
        return this.puts.put(index, value);
    }

    public Bytes put(char value) {
        return this.puts.put(value);
    }

    public Bytes put(int index, char value) {
        return this.puts.put(index, value);
    }

    public Bytes put(String value) {
        return this.puts.put(value);
    }

    public Bytes put(String value, Charset charset) {
        return this.puts.put(value, charset);
    }

    public Bytes put(int index, String value) {
        return this.puts.put(index, value);
    }

    public Bytes put(int index, String value, Charset charset) {
        return this.puts.put(index, value, charset);
    }

    public Bytes put(Bytes value) {
        return this.puts.put(value);
    }

    public Bytes put(int index, Bytes value) {
        return this.puts.put(index, value);
    }

    public short getUnsignedByte() {
        return this.gets.getUnsignedByte();
    }

    public short getUnsignedByte(int index) {
        return this.gets.getUnsignedByte(index);
    }

    public char getChar() {
        return this.gets.getChar();
    }

    public char getChar(int index) {
        return this.gets.getChar(index);
    }

    public short getShort() {
        return this.gets.getShort();
    }

    public int getUnsignedShort() {
        return this.gets.getUnsignedShort();
    }

    public short getShort(int index) {
        return this.gets.getShort(index);
    }

    public int getUnsignedShort(int index) {
        return this.gets.getUnsignedShort(index);
    }

    public int getInt() {
        return this.gets.getInt();
    }

    public long getUnsignedInt() {
        return this.gets.getUnsignedInt();
    }

    public int getInt(int index) {
        return this.gets.getInt(index);
    }

    public long getUnsignedInt(int index) {
        return this.gets.getUnsignedInt(index);
    }

    public long getLong() {
        return this.gets.getLong();
    }

    public long getLong(int index) {
        return this.gets.getLong(index);
    }

    public float getFloat() {
        return this.gets.getFloat();
    }

    public float getFloat(int index) {
        return this.gets.getFloat(index);
    }

    public double getDouble() {
        return this.gets.getDouble();
    }

    public double getDouble(int index) {
        return this.gets.getDouble(index);
    }

    public String getString() {
        return this.gets.getString();
    }

    public String getString(Charset charset) {
        return this.gets.getString(charset);
    }

    public String getString(int length) {
        return this.gets.getString(length);
    }

    public String getString(int length, Charset charset) {
        return this.gets.getString(length, charset);
    }
}

