/*
 * Copyright 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.appulse.utils.test;

import lombok.val;

import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

/**
 *
 * @author Artem Labazin
 * @since 1.5.0
 */
@SuppressWarnings("PMD.SystemPrintln")
public class TestMethodNamePrinter extends TestWatcher {

  @Override
  protected void starting (Description description) {
    val message = String.format("%nRUNNING TEST: %s.%s%n",
                                description.getClassName(),
                                description.getMethodName());
    System.out.println(message);
  }
}
