/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils.threads.executor;

import io.appulse.utils.threads.executor.ExecutorServiceWrapper;
import java.util.concurrent.ExecutorService;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExecutorServiceWithClientTrace
extends ExecutorServiceWrapper {
    private static final Logger log = LoggerFactory.getLogger(ExecutorServiceWithClientTrace.class);

    public ExecutorServiceWithClientTrace(ExecutorService delegate) {
        super(delegate);
    }

    @Override
    public void execute(@NonNull Runnable command) {
        if (command == null) {
            throw new NullPointerException("command");
        }
        Exception clientStack = new Exception("Client stack trace");
        String threadName = Thread.currentThread().getName();
        super.execute(() -> {
            try {
                command.run();
            }
            catch (Exception ex) {
                log.error("Exception '{}' in task submitted from thread '{}' here:", new Object[]{ex.getClass().getSimpleName(), threadName, clientStack});
                throw ex;
            }
        });
    }
}

